/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public enum ResourceType {
    DEFERRED_JS("text/javascript", ResourceType.vals("javascript"), ResourceType.vals("js")),
    JS("text/javascript", ResourceType.vals("javascript"), ResourceType.vals("js")),
    JSON("application/json", ResourceType.vals("json"), ResourceType.vals("json")),
    CSS("text/css", ResourceType.vals("css"), ResourceType.vals("css")),
    MAP("application/json", ResourceType.vals(new String[0]), ResourceType.vals("map")),
    ICO("image/x-icon", ResourceType.vals("x-icon"), ResourceType.vals("ico")),
    PNG("image/png", ResourceType.vals("png"), ResourceType.vals("png")),
    GIF("image/gif", ResourceType.vals("gif"), ResourceType.vals("gif")),
    JPG("image/jpeg", ResourceType.vals("jpeg", "jpg"), ResourceType.vals("jpg", "jpeg")),
    SVG("image/svg+xml", ResourceType.vals("svg"), ResourceType.vals("svg")),
    MP4("video/mp4", ResourceType.vals("mp4"), ResourceType.vals("mp4")),
    PDF("application/pdf", ResourceType.vals("pdf"), ResourceType.vals("pdf")),
    HTML("text/html", ResourceType.vals("html"), ResourceType.vals("html", "htm")),
    XML("application/xml", ResourceType.vals("xml"), ResourceType.vals("xml")),
    TEXT("text/plain", ResourceType.vals("plain"), ResourceType.vals("txt")),
    WOFF2("application/font-woff2", ResourceType.vals("woff2"), ResourceType.vals("woff2")),
    MULTIPART("multipart/form-data", ResourceType.vals("multipart"), ResourceType.vals(new String[0])),
    URLENCODED("application/x-www-form-urlencoded", ResourceType.vals("urlencoded"), ResourceType.vals(new String[0])),
    BINARY("application/octet-stream", ResourceType.vals("octet"), ResourceType.vals(new String[0])),
    RDFXML("application/rdf+xml", ResourceType.vals("rdf", "rdf+xml"), ResourceType.vals("rdf")),
    NTRIPLES("application/n-triples", ResourceType.vals("triples"), ResourceType.vals("nt")),
    TURTLE("text/turtle", ResourceType.vals("turtle"), ResourceType.vals("ttl")),
    NQUADS("application/n-quads", ResourceType.vals("quads"), ResourceType.vals("nq")),
    TRIG("application/trig", ResourceType.vals("trig"), ResourceType.vals("trig")),
    N3("text/n3", ResourceType.vals("n3"), ResourceType.vals("n3")),
    JSONLD("application/ld+json", ResourceType.vals("ld+json"), ResourceType.vals("jsonld"));

    public final String contentType;
    public final String[] contentLike;
    public final String[] extensions;
    private static final Map<String, ResourceType> EXTENSION_MAP;

    private static String[] vals(String ... values) {
        return values;
    }

    private ResourceType(String contentType, String[] contentLike, String[] extensions) {
        this.contentType = contentType;
        this.contentLike = contentLike;
        this.extensions = extensions;
    }

    public static ResourceType fromFileExtension(String path) {
        if (path == null) {
            return null;
        }
        int pos = path.lastIndexOf(46);
        if (pos == -1 || pos == path.length() - 1) {
            return null;
        }
        String extension = path.substring(pos + 1).trim().toLowerCase();
        return EXTENSION_MAP.get(extension);
    }

    public String getExtension() {
        return this.extensions.length == 0 ? null : this.extensions[0];
    }

    public boolean isVideo() {
        switch (this) {
            case MP4: {
                return true;
            }
        }
        return false;
    }

    public boolean isImage() {
        switch (this) {
            case BINARY: 
            case ICO: 
            case PNG: 
            case GIF: 
            case JPG: {
                return true;
            }
        }
        return false;
    }

    public boolean isUrlEncodedOrMultipart() {
        switch (this) {
            case URLENCODED: 
            case MULTIPART: {
                return true;
            }
        }
        return false;
    }

    public boolean isHtml() {
        return this == HTML;
    }

    public boolean isJson() {
        switch (this) {
            case JSON: 
            case JSONLD: {
                return true;
            }
        }
        return false;
    }

    public boolean isXml() {
        switch (this) {
            case XML: 
            case RDFXML: {
                return true;
            }
        }
        return false;
    }

    public boolean isText() {
        return this == TEXT;
    }

    public boolean isBinary() {
        switch (this) {
            case MP4: 
            case BINARY: 
            case ICO: 
            case PNG: 
            case GIF: 
            case JPG: 
            case PDF: {
                return true;
            }
        }
        return false;
    }

    public boolean isScript() {
        switch (this) {
            case JS: 
            case DEFERRED_JS: {
                return true;
            }
        }
        return false;
    }

    public static ResourceType fromContentType(String ct) {
        if (ct == null) {
            return null;
        }
        ct = ct.toLowerCase();
        for (ResourceType rt : ResourceType.values()) {
            if (ct.equals(rt.contentType)) {
                return rt;
            }
            for (String like : rt.contentLike) {
                if (!ct.contains(like)) continue;
                return rt;
            }
        }
        return null;
    }

    public static ResourceType fromObject(Object o) {
        return ResourceType.fromObject(o, null);
    }

    public static ResourceType fromObject(Object o, ResourceType defaultType) {
        if (o instanceof List || o instanceof Map) {
            return JSON;
        }
        if (o instanceof String) {
            return TEXT;
        }
        if (o instanceof Node) {
            return XML;
        }
        if (o instanceof byte[]) {
            return BINARY;
        }
        return defaultType;
    }

    static {
        EXTENSION_MAP = new HashMap<String, ResourceType>();
        for (ResourceType rt : ResourceType.values()) {
            for (String ext : rt.extensions) {
                EXTENSION_MAP.put(ext, rt);
            }
        }
    }
}

