/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.http.Session;
import com.intuit.karate.http.SessionStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class JvmSessionStore
implements SessionStore {
    public static final SessionStore INSTANCE = new JvmSessionStore();
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();

    private JvmSessionStore() {
    }

    @Override
    public Session create(long now, long expires) {
        String id = COUNTER.incrementAndGet() + "-" + System.currentTimeMillis();
        return new Session(id, new HashMap<String, Object>(), now, now, expires);
    }

    @Override
    public Session get(String id) {
        return this.sessions.get(id);
    }

    @Override
    public void save(Session session) {
        this.sessions.put(session.getId(), session);
    }

    @Override
    public void delete(String id) {
        this.sessions.remove(id);
    }
}

