/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.FileUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.http.Request;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpRequest {
    private long startTime;
    private long endTime;
    private String url;
    private String method;
    private Map<String, List<String>> headers;
    private byte[] body;
    private String bodyForDisplay;

    public void putHeader(String name, String ... values) {
        this.putHeader(name, Arrays.asList(values));
    }

    public void putHeader(String name, List<String> values) {
        if (this.headers == null) {
            this.headers = new HashMap<String, List<String>>();
        }
        for (String key : this.headers.keySet()) {
            if (!key.equalsIgnoreCase(name)) continue;
            name = key;
            break;
        }
        this.headers.put(name, values);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyAsString() {
        return FileUtils.toString(this.body);
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public String getBodyForDisplay() {
        return this.bodyForDisplay;
    }

    public void setBodyForDisplay(String bodyForDisplay) {
        this.bodyForDisplay = bodyForDisplay;
    }

    public List<String> getHeaderValues(String name) {
        return StringUtils.getIgnoreKeyCase(this.headers, name);
    }

    public void removeHeader(String name) {
        if (this.headers == null) {
            return;
        }
        for (String key : this.headers.keySet()) {
            if (!key.equalsIgnoreCase(name)) continue;
            name = key;
            break;
        }
        this.headers.remove(name);
    }

    public String getHeader(String name) {
        List<String> values = this.getHeaderValues(name);
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setContentType(String contentType) {
        this.putHeader("Content-Type", contentType);
    }

    public Request toRequest() {
        Request request = new Request();
        request.setStartTime(this.startTime);
        request.setEndTime(this.endTime);
        request.setMethod(this.method);
        request.setUrl(this.url);
        request.setHeaders(this.headers);
        request.setBody(this.body);
        return request;
    }

    public String toString() {
        return this.method + " " + this.url;
    }
}

