/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.CookieHeaderNames;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cookies {
    private static final Logger logger = LoggerFactory.getLogger(Cookies.class);
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String WRAP = "wrap";
    public static final String DOMAIN = "domain";
    public static final String PATH = "path";
    public static final String MAX_AGE = "max-age";
    public static final String SECURE = "secure";
    public static final String HTTP_ONLY = "httponly";
    public static final String SAME_SITE = "samesite";

    private Cookies() {
    }

    public static Map<String, Object> toMap(Cookie cookie) {
        DefaultCookie dc;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(NAME, cookie.name());
        map.put(VALUE, cookie.value());
        map.put(WRAP, cookie.wrap());
        map.put(DOMAIN, cookie.domain());
        map.put(PATH, cookie.path());
        map.put(MAX_AGE, cookie.maxAge());
        map.put(SECURE, cookie.isSecure());
        map.put(HTTP_ONLY, cookie.isHttpOnly());
        if (cookie instanceof DefaultCookie && (dc = (DefaultCookie)cookie).sameSite() != null) {
            map.put(SAME_SITE, dc.sameSite().name());
        }
        return map;
    }

    public static Cookie fromMap(Map<String, Object> map) {
        String sameSite;
        Boolean httpOnly;
        Boolean secure;
        Object maxAge;
        String path;
        String domain;
        String name = (String)map.get(NAME);
        String value = (String)map.get(VALUE);
        DefaultCookie cookie = new DefaultCookie(name, value);
        Boolean wrap = (Boolean)map.get(WRAP);
        if (wrap != null) {
            cookie.setWrap(wrap.booleanValue());
        }
        if ((domain = (String)map.get(DOMAIN)) != null) {
            cookie.setDomain(domain);
        }
        if ((path = (String)map.get(PATH)) != null) {
            cookie.setPath(path);
        }
        if ((maxAge = map.get(MAX_AGE)) != null) {
            cookie.setMaxAge(Long.parseLong("" + maxAge));
        }
        if ((secure = (Boolean)map.get(SECURE)) != null) {
            cookie.setSecure(secure.booleanValue());
        }
        if ((httpOnly = (Boolean)map.get(HTTP_ONLY)) != null) {
            cookie.setHttpOnly(httpOnly.booleanValue());
        }
        if ((sameSite = (String)map.get(SAME_SITE)) != null) {
            cookie.setSameSite(CookieHeaderNames.SameSite.valueOf((String)sameSite));
        }
        return cookie;
    }

    public static Map<String, Map> normalize(Object mapOrList) {
        HashMap<String, Map> cookies = new HashMap<String, Map>();
        if (mapOrList instanceof Map) {
            Map map2 = (Map)mapOrList;
            map2.forEach((k, v) -> {
                if (v instanceof String) {
                    HashMap<String, Object> cookie = new HashMap<String, Object>(2);
                    cookie.put(NAME, k);
                    cookie.put(VALUE, v);
                    cookies.put((String)k, cookie);
                } else if (v instanceof Map) {
                    Map cookie = (Map)v;
                    cookie.put(NAME, k);
                    cookies.put((String)k, cookie);
                }
            });
        } else if (mapOrList instanceof List) {
            List list = (List)mapOrList;
            list.forEach(map -> cookies.put((String)map.get(NAME), (Map)map));
        }
        return cookies;
    }
}

