/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.playwright;

import com.intuit.karate.Json;
import com.intuit.karate.driver.playwright.PlaywrightDriver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaywrightMessage {
    private static final Logger logger = LoggerFactory.getLogger(PlaywrightMessage.class);
    protected final PlaywrightDriver driver;
    private Integer id;
    private final String guid;
    private final String method;
    private Json params;
    private Json result;
    private Json error;
    private Integer timeout;

    public void sendWithoutWaiting() {
        this.driver.send(this);
    }

    public PlaywrightMessage send() {
        return this.send(null);
    }

    public PlaywrightMessage send(Predicate<PlaywrightMessage> condition) {
        return this.driver.sendAndWait(this, condition);
    }

    public boolean methodIs(String method) {
        return method.equals(this.method);
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public PlaywrightMessage param(String path, Object value) {
        if (this.params == null) {
            this.params = Json.object();
        }
        this.params.set(path, value);
        return this;
    }

    public PlaywrightMessage params(Json json) {
        this.params = json;
        return this;
    }

    public PlaywrightMessage params(Map<String, Object> map) {
        this.params = Json.of(map);
        return this;
    }

    public <T> T getParam(String path) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(path);
    }

    public <T> boolean paramHas(String path, T expected) {
        T actual = this.getParam(path);
        if (actual == null) {
            return expected == null;
        }
        return actual.equals(expected);
    }

    public Json getResult() {
        return this.result;
    }

    public <T> T getResult(String path) {
        if (this.result == null) {
            return null;
        }
        return this.result.get(path);
    }

    public <T> T getResultValue() {
        if (this.result == null) {
            return null;
        }
        Map map = (Map)this.result.get("value");
        return (T)PlaywrightMessage.recurse(map);
    }

    private static Object recurse(Map<String, Object> raw) {
        if (raw == null || raw.isEmpty()) {
            return null;
        }
        String key = raw.keySet().iterator().next();
        Object val = raw.get(key);
        switch (key) {
            case "o": {
                List objectItems = (List)val;
                HashMap<String, Object> map = new HashMap<String, Object>(objectItems.size());
                for (Map entry : objectItems) {
                    String entryKey = (String)entry.get("k");
                    Map entryValue = (Map)entry.get("v");
                    map.put(entryKey, PlaywrightMessage.recurse(entryValue));
                }
                return map;
            }
            case "a": {
                List arrayItems = (List)val;
                ArrayList<Object> list = new ArrayList<Object>(arrayItems.size());
                for (Map entry : arrayItems) {
                    list.add(PlaywrightMessage.recurse(entry));
                }
                return list;
            }
        }
        return val;
    }

    public boolean isError() {
        return this.error != null;
    }

    public Json getError() {
        return this.error;
    }

    public PlaywrightMessage(PlaywrightDriver driver, String method, String guid) {
        this.driver = driver;
        this.method = method;
        this.guid = guid;
        this.result = null;
        this.id = driver.nextId();
    }

    public PlaywrightMessage(PlaywrightDriver driver, Map<String, Object> map) {
        this.driver = driver;
        this.id = (Integer)map.get("id");
        this.guid = (String)map.get("guid");
        this.method = (String)map.get("method");
        Map temp = (Map)map.get("params");
        if (temp != null) {
            this.params = Json.of(temp);
        }
        if ((temp = (Map)map.get("result")) != null) {
            this.result = Json.of(temp);
        }
        if ((temp = (Map)map.get("error")) != null) {
            if (temp.containsKey("error")) {
                temp = (Map)temp.get("error");
            }
            this.error = Json.of(temp);
        }
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(4);
        if (this.id != null) {
            map.put("id", this.id);
        }
        map.put("guid", this.guid);
        map.put("method", this.method);
        if (this.params != null) {
            map.put("params", this.params.value());
        }
        return map;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getMethod() {
        return this.method;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.id == null) {
            sb.append("[guid: ").append(this.guid);
        } else {
            sb.append("[id: ").append(this.id);
            sb.append(", guid: ").append(this.guid);
        }
        if (this.method != null) {
            sb.append(", method: ").append(this.method);
        }
        if (this.params != null) {
            sb.append(", params: ").append(this.params);
        }
        if (this.result != null) {
            sb.append(", results: ").append(this.result);
        }
        if (this.error != null) {
            sb.append(", error: ").append(this.error);
        }
        sb.append("]");
        return sb.toString();
    }
}

