/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.microsoft;

import com.intuit.karate.Json;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.WebDriver;
import java.util.Map;

public class WinAppDriver
extends WebDriver {
    public static final String DRIVER_TYPE = "winappdriver";

    public WinAppDriver(DriverOptions options) {
        super(options);
    }

    public static WinAppDriver start(Map<String, Object> map, ScenarioRuntime sr) {
        DriverOptions options = new DriverOptions(map, sr, 4727, "C:/Program Files (x86)/Windows Application Driver/WinAppDriver");
        options.arg("" + options.port);
        return new WinAppDriver(options);
    }

    @Override
    public void activate() {
    }

    private String getElementSelector(String id) {
        Json json = Json.object();
        if (id.startsWith("/")) {
            json.set("using", "xpath").set("value", id);
        } else if (id.startsWith("@")) {
            json.set("using", "accessibility id").set("value", id.substring(1));
        } else if (id.startsWith("#")) {
            json.set("using", "id").set("value", id.substring(1));
        } else {
            json.set("using", "name").set("value", id);
        }
        return json.toString();
    }

    @Override
    public String elementId(String id) {
        String body = this.getElementSelector(id);
        return (String)this.http.path("element").postJson(body).json().getFirst("$..ELEMENT");
    }

    @Override
    public Element click(String locator) {
        String id = this.elementId(locator);
        this.http.path("element", id, "click").postJson("{}");
        return DriverElement.locatorExists(this, locator);
    }

    @Override
    public String text(String locator) {
        String id = this.elementId(locator);
        return (String)this.http.path("element", id, "text").get().json().get("value");
    }

    @Override
    protected String getJsonForInput(String text) {
        return Json.object().set("value[0]", text).toString();
    }
}

