/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.chrome;

import com.intuit.karate.FileUtils;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.WebDriver;
import com.intuit.karate.http.Response;
import java.util.Map;

public class ChromeWebDriver
extends WebDriver {
    public static final String DRIVER_TYPE = "chromedriver";

    public ChromeWebDriver(DriverOptions options) {
        super(options);
    }

    public static ChromeWebDriver start(Map<String, Object> map, ScenarioRuntime sr) {
        DriverOptions options = new DriverOptions(map, sr, 9515, DRIVER_TYPE);
        options.arg("--port=" + options.port);
        if (options.userDataDir != null) {
            options.arg("--user-data-dir=" + options.userDataDir);
        }
        return new ChromeWebDriver(options);
    }

    @Override
    public void activate() {
        if (!this.options.headless) {
            try {
                switch (FileUtils.getOsType()) {
                    case MACOSX: {
                        Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell app \"Chrome\" to activate"});
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("native window switch failed: {}", e.getMessage());
            }
        }
    }

    @Override
    protected boolean isJavaScriptError(Response res) {
        Object value = res.json().get("value");
        return value != null && value.toString().contains("javascript error");
    }

    @Override
    protected boolean isLocatorError(Response res) {
        Object value = res.json().get("value");
        return value.toString().contains("no such element");
    }

    @Override
    protected boolean isCookieError(Response res) {
        Object value = res.json().get("value");
        return value != null && value.toString().contains("unable to set cookie");
    }
}

