/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.appium;

import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverElement;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Element;
import com.intuit.karate.driver.MissingElement;
import com.intuit.karate.driver.appium.AppiumDriver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MobileDriverOptions
extends DriverOptions {
    public MobileDriverOptions(Map<String, Object> options, ScenarioRuntime sr, int defaultPort, String defaultExecutable) {
        super(options, sr, defaultPort, defaultExecutable);
    }

    public boolean isWebSession() {
        Map<String, Object> sessionPayload = super.getWebDriverSessionPayload();
        return MobileDriverOptions.getBrowserName(sessionPayload) != null;
    }

    @Override
    public Element waitForAny(Driver driver, String ... locators) {
        if (this.isWebSession()) {
            return super.waitForAny(driver, locators);
        }
        long startTime = System.currentTimeMillis();
        List<String> list = Arrays.asList(locators);
        boolean found = (Boolean)driver.waitUntil(() -> {
            for (String locator : list) {
                try {
                    ((AppiumDriver)driver).elementId(locator);
                    return true;
                }
                catch (RuntimeException re) {
                    this.logger.debug("failed to locate : {}", locator);
                }
            }
            return null;
        });
        this.disableRetry();
        if (!found) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            throw new RuntimeException("wait failed for: " + list + " after " + elapsedTime + " milliseconds");
        }
        if (locators.length == 1) {
            return DriverElement.locatorExists(driver, locators[0]);
        }
        for (String locator : locators) {
            Element temp = driver.optional(locator);
            if (!temp.isPresent()) continue;
            return temp;
        }
        throw new RuntimeException("unexpected wait failure for locators: " + list);
    }

    @Override
    public Element optional(Driver driver, String locator) {
        if (this.isWebSession()) {
            return super.optional(driver, locator);
        }
        try {
            this.retry(() -> {
                try {
                    ((AppiumDriver)driver).elementId(locator);
                    return true;
                }
                catch (RuntimeException re) {
                    return false;
                }
            }, b -> b, "optional (locator)", true);
            return DriverElement.locatorExists(driver, locator);
        }
        catch (RuntimeException re) {
            return new MissingElement(driver, locator);
        }
    }

    protected static String getBrowserName(Map<String, Object> sessionPayload) {
        Map capabilities = (Map)sessionPayload.get("capabilities");
        Map desiredCapabilities = (Map)sessionPayload.get("desiredCapabilities");
        if (capabilities != null) {
            if (capabilities.containsKey("firstMatch")) {
                List firstMatch = (List)capabilities.get("firstMatch");
                if (firstMatch.size() == 0) {
                    throw new RuntimeException("firstMatch node in webdriver session is empty");
                }
                return (String)((Map)firstMatch.get(0)).get("browserName");
            }
            return (String)capabilities.get("browserName");
        }
        if (desiredCapabilities != null) {
            return (String)desiredCapabilities.get("browserName");
        }
        return null;
    }
}

