/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.Tags;
import com.intuit.karate.report.ReportUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TagResults {
    private final Set<String> allTagKeys = new TreeSet<String>();
    private final Set<String> failedTagKeys = new TreeSet<String>();
    private final List<Map<String, Object>> featureTagsList = new ArrayList<Map<String, Object>>();

    public void addFeatureResult(FeatureResult fr) {
        HashMap<String, Object> featureTags = new HashMap<String, Object>();
        this.featureTagsList.add(featureTags);
        featureTags.put("featureSummary", fr.toSummaryJson());
        TreeSet<String> tagKeysSet = new TreeSet<String>();
        featureTags.put("tagKeys", tagKeysSet);
        TreeSet<String> failedTagKeysSet = new TreeSet<String>();
        featureTags.put("failedTagKeys", failedTagKeysSet);
        for (ScenarioResult sr : fr.getScenarioResults()) {
            Tags tags = sr.getScenario().getTagsEffective();
            this.allTagKeys.addAll(tags.getTagKeys());
            tagKeysSet.addAll(tags.getTagKeys());
            if (!sr.isFailed()) continue;
            this.failedTagKeys.addAll(tags.getTagKeys());
            failedTagKeysSet.addAll(tags.getTagKeys());
        }
    }

    public Map<String, Object> toKarateJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tagKeysPassed", this.allTagKeys.size() - this.failedTagKeys.size());
        map.put("tagKeysFailed", this.failedTagKeys.size());
        map.put("resultDate", ReportUtils.getDateString());
        map.put("tagKeys", this.allTagKeys);
        map.put("failedTagKeys", this.failedTagKeys);
        map.put("featureTags", this.featureTagsList);
        return map;
    }
}

