/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Background;
import com.intuit.karate.core.FeatureParser;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioOutline;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.Tag;
import com.intuit.karate.resource.FileResource;
import com.intuit.karate.resource.Resource;
import com.intuit.karate.resource.ResourceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Feature {
    public static final String KEYWORD = "Feature";
    private final Resource resource;
    private int line;
    private List<Tag> tags;
    private String name;
    private String description;
    private Background background;
    private List<FeatureSection> sections = new ArrayList<FeatureSection>();

    public static Feature read(String path) {
        return Feature.read(ResourceUtils.getResource(FileUtils.WORKING_DIR, path));
    }

    public static Feature read(File file) {
        return Feature.read(new FileResource(file));
    }

    public static Feature read(Resource resource) {
        Feature feature = new Feature(resource);
        FeatureParser.parse(feature);
        return feature;
    }

    private Feature(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getPackageQualifiedName() {
        return this.resource.getPackageQualifiedName();
    }

    public String getKarateJsonFileName() {
        return this.getPackageQualifiedName() + ".karate-json.txt";
    }

    public boolean isBackgroundPresent() {
        return this.background != null && this.background.getSteps() != null;
    }

    public String getNameAndDescription() {
        Object temp = "";
        if (!StringUtils.isBlank(this.name)) {
            temp = (String)temp + this.name;
        }
        if (!StringUtils.isBlank(this.description)) {
            if (!((String)temp).isEmpty()) {
                temp = (String)temp + " | ";
            }
            temp = (String)temp + this.description;
        }
        return temp;
    }

    public String getNameForReport() {
        if (this.name == null) {
            return "[" + this.resource.getFileNameWithoutExtension() + "]";
        }
        return "[" + this.resource.getFileNameWithoutExtension() + "] " + this.name;
    }

    public Step findStepByLine(int line) {
        for (FeatureSection section : this.sections) {
            List<Step> steps = section.isOutline() ? section.getScenarioOutline().getSteps() : section.getScenario().getStepsIncludingBackground();
            for (Step step : steps) {
                if (step.getLine() != line) continue;
                return step;
            }
        }
        return null;
    }

    public Scenario getSetup(String name) {
        for (FeatureSection section : this.sections) {
            Scenario scenario;
            List<Tag> foundTags;
            if (section.isOutline() || (foundTags = (scenario = section.getScenario()).getTags()) == null) continue;
            for (Tag tag : foundTags) {
                if (!"setup".equals(tag.getName())) continue;
                if (name == null) {
                    return scenario;
                }
                if (!tag.getValues().contains(name)) continue;
                return scenario;
            }
        }
        return null;
    }

    public void addSection(FeatureSection section) {
        section.setIndex(this.sections.size());
        this.sections.add(section);
    }

    public FeatureSection getSection(int sectionIndex) {
        return this.sections.get(sectionIndex);
    }

    public Scenario getScenario(int sectionIndex, int exampleIndex) {
        FeatureSection section = this.getSection(sectionIndex);
        if (exampleIndex == -1) {
            return section.getScenario();
        }
        ScenarioOutline outline = section.getScenarioOutline();
        return outline.getScenarios().get(exampleIndex);
    }

    public Step getStep(int sectionIndex, int exampleIndex, int stepIndex) {
        Scenario scenario = this.getScenario(sectionIndex, exampleIndex);
        List<Step> steps = scenario.getSteps();
        if (stepIndex == -1 || steps.isEmpty() || steps.size() <= stepIndex) {
            return null;
        }
        return steps.get(stepIndex);
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public List<FeatureSection> getSections() {
        return this.sections;
    }

    public void setSections(List<FeatureSection> sections) {
        this.sections = sections;
    }

    public String toString() {
        return this.resource.toString();
    }
}

