/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.Suite;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.TagResults;
import com.intuit.karate.core.TimelineResults;
import com.intuit.karate.report.ReportUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public class Results {
    private final Suite suite;
    private final int featuresPassed;
    private final int featuresFailed;
    private final int featuresSkipped;
    private final int scenariosPassed;
    private final int scenariosFailed;
    private final double timeTakenMillis;
    private final long endTime;
    private final List<String> errors = new ArrayList<String>();
    private final List<Map<String, Object>> featureSummary = new ArrayList<Map<String, Object>>();

    public static Results of(Suite suite) {
        return new Results(suite);
    }

    private Results(Suite suite) {
        this.suite = suite;
        this.endTime = suite.endTime == 0L ? System.currentTimeMillis() : suite.endTime;
        this.featuresSkipped = suite.skippedCount;
        AtomicInteger fp = new AtomicInteger();
        AtomicInteger ff = new AtomicInteger();
        AtomicInteger sp = new AtomicInteger();
        AtomicInteger sf = new AtomicInteger();
        AtomicInteger time = new AtomicInteger();
        TimelineResults timeline = new TimelineResults();
        TagResults tags = new TagResults();
        suite.getFeatureResults().forEach(fr -> {
            if (!fr.isEmpty()) {
                timeline.addFeatureResult((FeatureResult)fr);
                tags.addFeatureResult((FeatureResult)fr);
                if (fr.isFailed()) {
                    ff.incrementAndGet();
                } else {
                    fp.incrementAndGet();
                }
                Long duration = Math.round(fr.getDurationMillis());
                time.addAndGet(duration.intValue());
                this.featureSummary.add(fr.toSummaryJson());
            }
            sp.addAndGet(fr.getPassedCount());
            sf.addAndGet(fr.getFailedCount());
            this.errors.addAll(fr.getErrors());
        });
        this.featuresPassed = fp.get();
        this.featuresFailed = ff.get();
        this.scenariosPassed = sp.get();
        this.scenariosFailed = sf.get();
        this.timeTakenMillis = time.get();
        this.saveStatsJson();
        this.printStats();
        if (suite.outputHtmlReport) {
            String displayEnv = StringUtils.isBlank(suite.env) ? "\n" : " | env: " + suite.env + "\n";
            suite.suiteReports.timelineReport(suite, timeline).render();
            suite.suiteReports.tagsReport(suite, tags).render();
            File file = suite.suiteReports.summaryReport(suite, this).render();
            System.out.println("\nHTML report: (paste into browser to view) | Karate version: " + FileUtils.KARATE_VERSION + displayEnv + file.toPath().toUri() + "\n===================================================================\n");
        }
    }

    public Stream<FeatureResult> getFeatureResults() {
        return this.suite.getFeatureResults();
    }

    public Stream<ScenarioResult> getScenarioResults() {
        return this.suite.getScenarioResults();
    }

    private void saveStatsJson() {
        String json = JsonUtils.toJson(this.toKarateJson());
        File file = new File(this.suite.reportDir + File.separator + "karate-summary-json.txt");
        FileUtils.writeToFile(file, json);
    }

    private void printStats() {
        String displayEnv = StringUtils.isBlank(this.suite.env) ? "" : " | env: " + this.suite.env;
        System.out.println("Karate version: " + FileUtils.KARATE_VERSION + displayEnv);
        System.out.println("======================================================");
        System.out.println(String.format("elapsed: %6.2f | threads: %4d | thread time: %.2f ", this.getElapsedTime() / 1000.0, this.suite.threadCount, this.timeTakenMillis / 1000.0));
        System.out.println(String.format("features: %5d | skipped: %4d | efficiency: %.2f", this.getFeaturesTotal(), this.featuresSkipped, this.getEfficiency()));
        System.out.println(String.format("scenarios: %4d | passed: %5d | failed: %d", this.getScenariosTotal(), this.scenariosPassed, this.scenariosFailed));
        System.out.println("======================================================");
        if (!this.errors.isEmpty()) {
            System.out.println(">>> failed features:");
            System.out.println(this.getErrorMessages());
            System.out.println("<<<");
        }
    }

    public Map<String, Object> toKarateJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", FileUtils.KARATE_VERSION);
        map.put("env", this.suite.env);
        map.put("threads", this.suite.threadCount);
        map.put("featuresPassed", this.featuresPassed);
        map.put("featuresFailed", this.featuresFailed);
        map.put("featuresSkipped", this.featuresSkipped);
        map.put("scenariosPassed", this.scenariosPassed);
        map.put("scenariosfailed", this.errors.size());
        map.put("elapsedTime", this.getElapsedTime());
        map.put("totalTime", this.getTimeTakenMillis());
        map.put("efficiency", this.getEfficiency());
        map.put("resultDate", ReportUtils.getDateString());
        map.put("featureSummary", this.featureSummary);
        return map;
    }

    public String getReportDir() {
        return this.suite.reportDir;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public double getElapsedTime() {
        return this.endTime - this.suite.startTime;
    }

    public double getEfficiency() {
        return this.timeTakenMillis / (this.getElapsedTime() * (double)this.suite.threadCount);
    }

    public int getScenariosPassed() {
        return this.scenariosPassed;
    }

    public int getScenariosFailed() {
        return this.scenariosFailed;
    }

    public int getScenariosTotal() {
        return this.scenariosPassed + this.scenariosFailed;
    }

    public int getFeaturesTotal() {
        return this.featuresPassed + this.featuresFailed;
    }

    public int getFeaturesPassed() {
        return this.featuresPassed;
    }

    public int getFeaturesFailed() {
        return this.featuresFailed;
    }

    public int getFailCount() {
        return this.errors.size();
    }

    public double getTimeTakenMillis() {
        return this.timeTakenMillis;
    }

    public long getStartTime() {
        return this.suite.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getErrorMessages() {
        return StringUtils.join(this.errors, "\n");
    }

    public Suite getSuite() {
        return this.suite;
    }
}

