/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.LogAppender;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class Logger {
    private static final String DEFAULT_PACKAGE = "com.intuit.karate";
    private final org.slf4j.Logger LOGGER;
    private final DateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
    private LogAppender appender = LogAppender.NO_OP;
    private boolean appendOnly;
    private boolean logOnly;

    public void setAppender(LogAppender appender) {
        this.appender = appender;
    }

    public LogAppender getAppender() {
        return this.appender;
    }

    public boolean isTraceEnabled() {
        return this.LOGGER.isTraceEnabled();
    }

    public void setAppendOnly(boolean appendOnly) {
        this.appendOnly = appendOnly;
    }

    public boolean isAppendOnly() {
        return this.appendOnly;
    }

    public void setLogOnly(boolean logOnly) {
        this.logOnly = logOnly;
    }

    public boolean isLogOnly() {
        return this.logOnly;
    }

    public Logger(Class clazz) {
        this.LOGGER = LoggerFactory.getLogger((Class)clazz);
    }

    public Logger(String name) {
        this.LOGGER = LoggerFactory.getLogger((String)name);
    }

    public Logger() {
        this(DEFAULT_PACKAGE);
    }

    public void trace(String format, Object ... arguments) {
        if (this.LOGGER.isTraceEnabled()) {
            if (!this.appendOnly) {
                this.LOGGER.trace(format, arguments);
            }
            if (!this.logOnly) {
                this.formatAndAppend(format, arguments);
            }
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.LOGGER.isDebugEnabled()) {
            if (!this.appendOnly) {
                this.LOGGER.debug(format, arguments);
            }
            if (!this.logOnly) {
                this.formatAndAppend(format, arguments);
            }
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.LOGGER.isInfoEnabled()) {
            if (!this.appendOnly) {
                this.LOGGER.info(format, arguments);
            }
            if (!this.logOnly) {
                this.formatAndAppend(format, arguments);
            }
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.LOGGER.isWarnEnabled()) {
            if (!this.appendOnly) {
                this.LOGGER.warn(format, arguments);
            }
            if (!this.logOnly) {
                this.formatAndAppend(format, arguments);
            }
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.LOGGER.isErrorEnabled()) {
            if (!this.appendOnly) {
                this.LOGGER.error(format, arguments);
            }
            if (!this.logOnly) {
                this.formatAndAppend(format, arguments);
            }
        }
    }

    private String getFormattedDate() {
        Date now = new Date();
        String dateText = this.dateFormatter.format(now);
        return dateText;
    }

    private void formatAndAppend(String format, Object ... arguments) {
        if (this.appender == null) {
            return;
        }
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.append(tp.getMessage());
    }

    private void append(String message) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getFormattedDate()).append(' ').append(message).append('\n');
        this.appender.append(buf.toString());
    }
}

