/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.text;

import io.jstuff.text.StringMatcher;
import java.util.Objects;

public class EndsWithMatcher
implements StringMatcher {
    private final String string;

    public EndsWithMatcher(String string) {
        this.string = Objects.requireNonNull(string, "String must not be null");
    }

    @Override
    public boolean matches(CharSequence target) {
        int stringLength = this.string.length();
        int targetLength = target.length();
        if (targetLength < stringLength) {
            return false;
        }
        return StringMatcher.compareCS(target, targetLength - stringLength, this.string, 0, stringLength);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EndsWithMatcher)) {
            return false;
        }
        return this.string.equals(((EndsWithMatcher)obj).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

