/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.text;

import io.jstuff.text.StringMatcher;
import java.util.Objects;

public class CaseInsensitiveMatcher
implements StringMatcher {
    private final String string;

    public CaseInsensitiveMatcher(String string) {
        this.string = Objects.requireNonNull(string, "String must not be null");
    }

    @Override
    public boolean matches(CharSequence target) {
        Objects.requireNonNull(target, "Target must not be null");
        int n = target.length();
        if (n != this.string.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char stringChar;
            char targetChar = target.charAt(i);
            if (targetChar == (stringChar = this.string.charAt(i)) || Character.isLowerCase(stringChar) && stringChar == Character.toLowerCase(targetChar) || Character.isUpperCase(stringChar) && stringChar == Character.toUpperCase(targetChar)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CaseInsensitiveMatcher)) {
            return false;
        }
        return this.string.equals(((CaseInsensitiveMatcher)obj).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

