/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.text;

import io.jstuff.text.AlternateMatcher;
import io.jstuff.text.CaseInsensitiveMatcher;
import io.jstuff.text.PatternMatcher;
import io.jstuff.text.SimpleMatcher;
import io.jstuff.text.WildcardMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;

@FunctionalInterface
public interface StringMatcher {
    public boolean matches(CharSequence var1);

    public static WildcardMatcher wildcard(String pattern) {
        return new WildcardMatcher(pattern);
    }

    public static SimpleMatcher simple(String string) {
        return new SimpleMatcher(string);
    }

    public static CaseInsensitiveMatcher caseInsensitive(String string) {
        return new CaseInsensitiveMatcher(string);
    }

    public static PatternMatcher pattern(Pattern pattern) {
        return new PatternMatcher(pattern);
    }

    public static AlternateMatcher alternate(StringMatcher ... matchers) {
        for (StringMatcher matcher : matchers) {
            Objects.requireNonNull(matcher, "Matcher must not be null");
        }
        return new AlternateMatcher(Arrays.copyOf(matchers, matchers.length));
    }

    public static AlternateMatcher alternate(String ... strings) {
        int n = strings.length;
        StringMatcher[] matchers = new StringMatcher[n];
        for (int i = 0; i < n; ++i) {
            matchers[i] = new SimpleMatcher(Objects.requireNonNull(strings[i], "String must not be null"));
        }
        return new AlternateMatcher(matchers);
    }

    public static AlternateMatcher alternate(Collection<String> strings) {
        StringMatcher[] matchers = new StringMatcher[strings.size()];
        int i = 0;
        for (String string : strings) {
            matchers[i++] = new SimpleMatcher(Objects.requireNonNull(string, "String must not be null"));
        }
        return new AlternateMatcher(matchers);
    }
}

