/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.AbstractIntAcceptor;
import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.CodePoint_UTF16;
import io.jstuff.pipeline.codec.DecoderFactory;
import io.jstuff.pipeline.codec.DynamicDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public class DynamicReader
extends Reader {
    private final InputStream inputStream;
    private final CharAcceptor charAcceptor;
    private final DynamicDecoder<Void> pipeline;
    private final char[] overflow;
    private int overflowIndex;

    public DynamicReader(InputStream inputStream) {
        this(inputStream, null);
    }

    public DynamicReader(InputStream inputStream, Charset charset) {
        this.inputStream = inputStream;
        this.charAcceptor = new CharAcceptor();
        this.pipeline = new DynamicDecoder<Void>(new CodePoint_UTF16<Void>(this.charAcceptor), charset);
        this.overflow = new char[8];
        this.overflowIndex = 0;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.overflowIndex > 0) {
            if (this.overflowIndex > len) {
                this.overflowIndex -= len;
                System.arraycopy(this.overflow, 0, cbuf, off, len);
                System.arraycopy(this.overflow, len, this.overflow, 0, this.overflowIndex);
                return len;
            }
            System.arraycopy(this.overflow, 0, cbuf, off, this.overflowIndex);
            if (this.overflowIndex == len) {
                this.overflowIndex = 0;
                return len;
            }
            off += this.overflowIndex;
            len -= this.overflowIndex;
            this.overflowIndex = 0;
        }
        this.charAcceptor.setBuffer(cbuf, off, len);
        while (!this.charAcceptor.isFinished()) {
            try {
                this.pipeline.accept(this.inputStream.read());
            }
            catch (Exception e) {
                throw new IOException("Unexpected exception in pipeline", e);
            }
        }
        int count = this.charAcceptor.getCount();
        if (count == 0 && this.charAcceptor.isClosed()) {
            return -1;
        }
        return count;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public void switchTo(IntAcceptor<? extends Void> delegate) {
        this.pipeline.switchTo(delegate);
    }

    public void switchTo(Charset charset) {
        this.switchTo(DecoderFactory.getDecoder(charset, this.pipeline.getDownstream()));
    }

    public void switchTo(String charsetName) {
        this.switchTo(DecoderFactory.getDecoder(charsetName, this.pipeline.getDownstream()));
    }

    private class CharAcceptor
    extends AbstractIntAcceptor<Void> {
        private char[] cbuf;
        private int off;
        private int len;
        private int count;

        private CharAcceptor() {
        }

        public void setBuffer(char[] cbuf, int off, int len) {
            this.cbuf = cbuf;
            this.off = off;
            this.len = len;
            this.count = 0;
        }

        @Override
        public void acceptInt(int value) {
            if (this.count < this.len) {
                this.cbuf[this.off + this.count++] = (char)value;
            } else {
                ((DynamicReader)DynamicReader.this).overflow[((DynamicReader)DynamicReader.this).overflowIndex++] = (char)value;
            }
        }

        public boolean isFinished() {
            return this.isClosed() || this.count >= this.len;
        }

        public int getCount() {
            return this.count;
        }
    }
}

