/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.ErrorHandlingIntPipeline;
import io.jstuff.pipeline.codec.ErrorStrategy;

public class DecodingPipeline<R>
extends ErrorHandlingIntPipeline<R> {
    private final String table;

    public DecodingPipeline(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy, String table) {
        super(downstream, errorStrategy);
        this.table = table;
    }

    @Override
    public void acceptInt(int value) {
        if (value >= 0 && value <= 127) {
            this.emit(value);
        } else if (value >= 128 && value <= 255) {
            this.emit(this.table.charAt(value - 128));
        } else {
            this.handleError(value);
        }
    }
}

