/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.StringAcceptor;
import io.jstuff.pipeline.codec.ErrorHandlingIntPipeline;
import io.jstuff.pipeline.codec.ErrorStrategy;
import java.util.List;

public class CodePoint_UTF16<R>
extends ErrorHandlingIntPipeline<R> {
    public CodePoint_UTF16(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        super(downstream, errorStrategy);
    }

    public CodePoint_UTF16(IntAcceptor<? extends R> downstream) {
        super(downstream, ErrorStrategy.THROW_EXCEPTION);
    }

    @Override
    public void acceptInt(int value) {
        if (Character.isBmpCodePoint(value)) {
            this.emit(value);
        } else {
            this.emit(Character.highSurrogate(value));
            this.emit(Character.lowSurrogate(value));
        }
    }

    public static String convert(List<Integer> input, ErrorStrategy errorStrategy) {
        CodePoint_UTF16<String> pipe = new CodePoint_UTF16<String>(new StringAcceptor(), errorStrategy);
        pipe.accept(input);
        pipe.safeClose();
        return (String)pipe.getResult();
    }

    public static String convert(List<Integer> input) {
        return CodePoint_UTF16.convert(input, ErrorStrategy.THROW_EXCEPTION);
    }
}

