/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.base64;

import io.jstuff.pipeline.ByteArrayAcceptor;
import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.ListIntAcceptor;
import io.jstuff.pipeline.StringAcceptor;
import io.jstuff.pipeline.codec.ErrorHandlingIntPipeline;
import io.jstuff.pipeline.codec.ErrorStrategy;
import java.util.List;

public class Base64Encoder<R>
extends ErrorHandlingIntPipeline<R> {
    public static final byte[] encodingArrayMain;
    public static final byte[] encodingArrayURL;
    private final byte[] encodingArray;
    private final boolean urlSafe;
    private State state = State.FIRST;
    private int saved;

    public Base64Encoder(IntAcceptor<? extends R> downstream, boolean urlSafe, ErrorStrategy errorStrategy) {
        super(downstream, errorStrategy);
        this.encodingArray = urlSafe ? encodingArrayURL : encodingArrayMain;
        this.urlSafe = urlSafe;
    }

    public Base64Encoder(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        this(downstream, false, errorStrategy);
    }

    public Base64Encoder(IntAcceptor<? extends R> downstream, boolean urlSafe) {
        this(downstream, urlSafe, ErrorStrategy.DEFAULT);
    }

    public Base64Encoder(IntAcceptor<? extends R> downstream) {
        this(downstream, false, ErrorStrategy.DEFAULT);
    }

    @Override
    public void acceptInt(int value) {
        if (value > 255) {
            this.handleError(value);
            return;
        }
        switch (this.state) {
            case FIRST: {
                this.emit(this.encodingArray[value >> 2 & 0x3F]);
                this.saved = value;
                this.state = State.SECOND;
                break;
            }
            case SECOND: {
                this.emit(this.encodingArray[this.saved << 4 & 0x30 | value >> 4 & 0xF]);
                this.saved = value;
                this.state = State.THIRD;
                break;
            }
            case THIRD: {
                this.emit(this.encodingArray[this.saved << 2 & 0x3C | value >> 6 & 3]);
                this.emit(this.encodingArray[value & 0x3F]);
                this.state = State.FIRST;
            }
        }
    }

    @Override
    public void close() {
        switch (this.state) {
            case FIRST: {
                break;
            }
            case SECOND: {
                this.emit(this.encodingArray[this.saved << 4 & 0x30]);
                if (this.urlSafe) break;
                this.emit(61);
                this.emit(61);
                break;
            }
            case THIRD: {
                this.emit(this.encodingArray[this.saved << 2 & 0x3C]);
                if (this.urlSafe) break;
                this.emit(61);
            }
        }
    }

    public static byte[] convert(byte[] input, boolean urlSafe, ErrorStrategy errorStrategy) {
        Base64Encoder<byte[]> pipe = new Base64Encoder<byte[]>(new ByteArrayAcceptor(), urlSafe, errorStrategy);
        pipe.accept(input);
        pipe.safeClose();
        return (byte[])pipe.getResult();
    }

    public static byte[] convert(byte[] input, ErrorStrategy errorStrategy) {
        return Base64Encoder.convert(input, false, errorStrategy);
    }

    public static byte[] convert(byte[] input, boolean urlSafe) {
        return Base64Encoder.convert(input, urlSafe, ErrorStrategy.THROW_EXCEPTION);
    }

    public static byte[] convert(byte[] input) {
        return Base64Encoder.convert(input, false, ErrorStrategy.THROW_EXCEPTION);
    }

    public static String convert(String input, boolean urlSafe, ErrorStrategy errorStrategy) {
        Base64Encoder<String> pipe = new Base64Encoder<String>(new StringAcceptor(), urlSafe, errorStrategy);
        pipe.accept(input);
        pipe.safeClose();
        return (String)pipe.getResult();
    }

    public static String convert(String input, ErrorStrategy errorStrategy) {
        return Base64Encoder.convert(input, false, errorStrategy);
    }

    public static String convert(String input, boolean urlSafe) {
        return Base64Encoder.convert(input, urlSafe, ErrorStrategy.THROW_EXCEPTION);
    }

    public static String convert(String input) {
        return Base64Encoder.convert(input, false, ErrorStrategy.THROW_EXCEPTION);
    }

    public static List<Integer> convert(List<Integer> input, boolean urlSafe, ErrorStrategy errorStrategy) {
        Base64Encoder<List<Integer>> pipe = new Base64Encoder<List<Integer>>(new ListIntAcceptor(), urlSafe, errorStrategy);
        pipe.accept(input);
        pipe.safeClose();
        return (List)pipe.getResult();
    }

    public static List<Integer> convert(List<Integer> input, ErrorStrategy errorStrategy) {
        return Base64Encoder.convert(input, false, errorStrategy);
    }

    public static List<Integer> convert(List<Integer> input, boolean urlSafe) {
        return Base64Encoder.convert(input, urlSafe, ErrorStrategy.THROW_EXCEPTION);
    }

    public static List<Integer> convert(List<Integer> input) {
        return Base64Encoder.convert(input, false, ErrorStrategy.THROW_EXCEPTION);
    }

    static {
        int i;
        encodingArrayMain = new byte[64];
        encodingArrayURL = new byte[64];
        for (i = 0; i < 26; ++i) {
            Base64Encoder.encodingArrayMain[i] = (byte)(65 + i);
            Base64Encoder.encodingArrayURL[i] = (byte)(65 + i);
        }
        for (i = 0; i < 26; ++i) {
            Base64Encoder.encodingArrayMain[i + 26] = (byte)(97 + i);
            Base64Encoder.encodingArrayURL[i + 26] = (byte)(97 + i);
        }
        for (i = 0; i < 10; ++i) {
            Base64Encoder.encodingArrayMain[i + 52] = (byte)(48 + i);
            Base64Encoder.encodingArrayURL[i + 52] = (byte)(48 + i);
        }
        Base64Encoder.encodingArrayMain[62] = 43;
        Base64Encoder.encodingArrayURL[62] = 45;
        Base64Encoder.encodingArrayMain[63] = 47;
        Base64Encoder.encodingArrayURL[63] = 95;
    }

    public static enum State {
        FIRST,
        SECOND,
        THIRD;

    }
}

