/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline;

import io.jstuff.pipeline.AbstractIntAcceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListIntAcceptor
extends AbstractIntAcceptor<List<Integer>> {
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final List<Integer> list;

    public ListIntAcceptor(int initialCapacity) {
        this.list = new ArrayList<Integer>(initialCapacity);
    }

    public ListIntAcceptor() {
        this(10);
    }

    public ListIntAcceptor(List<Integer> list) {
        this.list = list;
    }

    @Override
    public void acceptInt(int value) {
        this.list.add(value);
    }

    @Override
    public List<Integer> getResult() {
        return Collections.unmodifiableList(this.list);
    }

    public int getSize() {
        return this.list.size();
    }
}

