/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.uri;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.EncoderBase;
import io.jstuff.pipeline.uri.URIEncoder;
import io.jstuff.util.IntOutput;

public class FullURIEncoder<R>
extends EncoderBase<R> {
    private final boolean encodeSpaceAsPlus;

    public FullURIEncoder(IntAcceptor<? extends R> downstream, boolean encodeSpaceAsPlus) {
        super(downstream);
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
    }

    public FullURIEncoder(IntAcceptor<? extends R> downstream) {
        this(downstream, false);
    }

    @Override
    public void acceptInt(int value) {
        if (value == 32 && this.encodeSpaceAsPlus) {
            this.emit(43);
        } else if (!URIEncoder.isUnreservedURI(value) && !FullURIEncoder.isSyntaxURI(value)) {
            this.emit(37);
            IntOutput.output2Hex((int)value, this::emit);
        } else {
            this.emit(value);
        }
    }

    public static boolean isSyntaxURI(int ch) {
        return ch == 33 || ch == 35 || ch == 36 || ch >= 38 && ch <= 47 || ch == 58 || ch == 59 || ch == 61 || ch == 63 || ch == 64;
    }
}

