/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.ErrorStrategy;
import io.jstuff.pipeline.codec.ErrorStrategyBase;
import java.util.function.IntConsumer;

public class UTF8_UTF16<R>
extends ErrorStrategyBase<R> {
    private final IntConsumer threeByte1 = i -> this.intermediate(i, this::terminal);
    private final IntConsumer fourByte2 = i -> this.intermediate(i, this::terminal);
    private final IntConsumer fourByte1 = i -> this.intermediate(i, this.fourByte2);
    private final IntConsumer normal;
    private IntConsumer state = this.normal = i -> {
        if (i == -1 || (i & 0x80) == 0) {
            this.emit(i);
        } else if ((i & 0x40) == 0) {
            this.handleError(i);
        } else if ((i & 0x20) == 0) {
            this.startSequence(i & 0x1F, this::terminal);
        } else if ((i & 0x10) == 0) {
            this.startSequence(i & 0xF, this.threeByte1);
        } else if ((i & 8) == 0) {
            this.startSequence(i & 7, this.fourByte1);
        } else {
            this.handleError(i);
        }
    };
    private int codePoint;

    public UTF8_UTF16(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy) {
        super(downstream, errorStrategy);
    }

    public UTF8_UTF16(IntAcceptor<? extends R> downstream) {
        super(downstream, ErrorStrategy.THROW_EXCEPTION);
    }

    @Override
    public void acceptInt(int value) {
        this.state.accept(value);
    }

    @Override
    public boolean isStageComplete() {
        return this.state == this.normal;
    }

    private void startSequence(int i, IntConsumer nextState) {
        this.codePoint = i;
        this.state = nextState;
    }

    private void intermediate(int i, IntConsumer nextState) {
        if ((i & 0xC0) == 128) {
            this.codePoint = this.codePoint << 6 | i & 0x3F;
            this.state = nextState;
        } else {
            this.handleError(i);
            this.state = this.normal;
        }
    }

    private void terminal(int i) {
        if ((i & 0xC0) == 128) {
            int c = this.codePoint << 6 | i & 0x3F;
            if (Character.isBmpCodePoint(c)) {
                this.emit(c);
            } else {
                this.emit(Character.highSurrogate(c));
                this.emit(Character.lowSurrogate(c));
            }
        } else {
            this.handleError(i);
        }
        this.state = this.normal;
    }
}

