/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.codec;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.ErrorStrategy;
import io.jstuff.pipeline.codec.ErrorStrategyBase;
import java.util.Arrays;

public class EncodingPipeline<R>
extends ErrorStrategyBase<R> {
    private final int[] reverseTable;

    public EncodingPipeline(IntAcceptor<? extends R> downstream, ErrorStrategy errorStrategy, int[] reverseTable) {
        super(downstream, errorStrategy);
        this.reverseTable = reverseTable;
    }

    @Override
    public void acceptInt(int value) {
        if (value >= 0 && value <= 127) {
            this.emit(value);
        } else {
            int lo = 0;
            int hi = this.reverseTable.length;
            while (lo < hi) {
                int mid = hi + lo >>> 1;
                int entry = this.reverseTable[mid];
                int mapped = entry >>> 16;
                if (mapped < value) {
                    lo = mid + 1;
                    continue;
                }
                if (mapped > value) {
                    hi = mid;
                    continue;
                }
                this.emit(entry & 0xFFFF);
                return;
            }
            this.handleError(value);
        }
    }

    static int[] createReverseTable(String table) {
        int[] result = new int[table.length()];
        int n = table.length();
        for (int i = 0; i < n; ++i) {
            result[i] = table.charAt(i) << 16 | 0x80 | i;
        }
        Arrays.sort(result);
        return result;
    }
}

