/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.uri;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.EncoderBase;
import io.jstuff.util.IntOutput;

public class URIEncoder<R>
extends EncoderBase<R> {
    private final boolean encodeSpaceAsPlus;

    public URIEncoder(IntAcceptor<? extends R> downstream, boolean encodeSpaceAsPlus) {
        super(downstream);
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
    }

    public URIEncoder(IntAcceptor<? extends R> downstream) {
        this(downstream, false);
    }

    @Override
    public void acceptInt(int value) {
        if (value == 32 && this.encodeSpaceAsPlus) {
            this.emit(43);
        } else if (!URIEncoder.isUnreservedURI(value)) {
            this.emit(37);
            IntOutput.output2Hex((int)value, this::emit);
        } else {
            this.emit(value);
        }
    }

    public static boolean isUnreservedURI(int ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch == 45 || ch == 46 || ch == 95 || ch == 126;
    }
}

