/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.html;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.codec.EncoderBase;
import io.jstuff.pipeline.xxml.MappingEntry;

public class HTMLEncoder<R>
extends EncoderBase<R> {
    public static final String[] baseEntities = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    public static final MappingEntry[] mappedEntities = new MappingEntry[]{new MappingEntry(338, "OElig"), new MappingEntry(339, "oelig"), new MappingEntry(352, "Scaron"), new MappingEntry(353, "scaron"), new MappingEntry(376, "Yuml"), new MappingEntry(402, "fnof"), new MappingEntry(710, "circ"), new MappingEntry(732, "tilde"), new MappingEntry(913, "Alpha"), new MappingEntry(914, "Beta"), new MappingEntry(915, "Gamma"), new MappingEntry(916, "Delta"), new MappingEntry(917, "Epsilon"), new MappingEntry(918, "Zeta"), new MappingEntry(919, "Eta"), new MappingEntry(920, "Theta"), new MappingEntry(921, "Iota"), new MappingEntry(922, "Kappa"), new MappingEntry(923, "Lambda"), new MappingEntry(924, "Mu"), new MappingEntry(925, "Nu"), new MappingEntry(926, "Xi"), new MappingEntry(927, "Omicron"), new MappingEntry(928, "Pi"), new MappingEntry(929, "Rho"), new MappingEntry(931, "Sigma"), new MappingEntry(932, "Tau"), new MappingEntry(933, "Upsilon"), new MappingEntry(934, "Phi"), new MappingEntry(935, "Chi"), new MappingEntry(936, "Psi"), new MappingEntry(937, "Omega"), new MappingEntry(945, "alpha"), new MappingEntry(946, "beta"), new MappingEntry(947, "gamma"), new MappingEntry(948, "delta"), new MappingEntry(949, "epsilon"), new MappingEntry(950, "zeta"), new MappingEntry(951, "eta"), new MappingEntry(952, "theta"), new MappingEntry(953, "iota"), new MappingEntry(954, "kappa"), new MappingEntry(955, "lambda"), new MappingEntry(956, "mu"), new MappingEntry(957, "nu"), new MappingEntry(958, "xi"), new MappingEntry(959, "omicron"), new MappingEntry(960, "pi"), new MappingEntry(961, "rho"), new MappingEntry(962, "sigmaf"), new MappingEntry(963, "sigma"), new MappingEntry(964, "tau"), new MappingEntry(965, "upsilon"), new MappingEntry(966, "phi"), new MappingEntry(967, "chi"), new MappingEntry(968, "psi"), new MappingEntry(969, "omega"), new MappingEntry(977, "thetasym"), new MappingEntry(978, "upsih"), new MappingEntry(982, "piv"), new MappingEntry(8194, "ensp"), new MappingEntry(8195, "emsp"), new MappingEntry(8201, "thinsp"), new MappingEntry(8204, "zwnj"), new MappingEntry(8205, "zwj"), new MappingEntry(8206, "lrm"), new MappingEntry(8207, "rlm"), new MappingEntry(8211, "ndash"), new MappingEntry(8212, "mdash"), new MappingEntry(8216, "lsquo"), new MappingEntry(8217, "rsquo"), new MappingEntry(8218, "sbquo"), new MappingEntry(8220, "ldquo"), new MappingEntry(8221, "rdquo"), new MappingEntry(8222, "bdquo"), new MappingEntry(8224, "dagger"), new MappingEntry(8225, "Dagger"), new MappingEntry(8226, "bull"), new MappingEntry(8230, "hellip"), new MappingEntry(8240, "permil"), new MappingEntry(8242, "prime"), new MappingEntry(8243, "Prime"), new MappingEntry(8249, "lsaquo"), new MappingEntry(8250, "rsaquo"), new MappingEntry(8254, "oline"), new MappingEntry(8260, "frasl"), new MappingEntry(8364, "euro"), new MappingEntry(8465, "image"), new MappingEntry(8472, "weierp"), new MappingEntry(8476, "real"), new MappingEntry(8482, "trade"), new MappingEntry(8501, "alefsym"), new MappingEntry(8592, "larr"), new MappingEntry(8593, "uarr"), new MappingEntry(8594, "rarr"), new MappingEntry(8595, "darr"), new MappingEntry(8596, "harr"), new MappingEntry(8629, "crarr"), new MappingEntry(8656, "lArr"), new MappingEntry(8657, "uArr"), new MappingEntry(8658, "rArr"), new MappingEntry(8659, "dArr"), new MappingEntry(8660, "hArr"), new MappingEntry(8704, "forall"), new MappingEntry(8706, "part"), new MappingEntry(8707, "exist"), new MappingEntry(8709, "empty"), new MappingEntry(8711, "nabla"), new MappingEntry(8712, "isin"), new MappingEntry(8713, "notin"), new MappingEntry(8715, "ni"), new MappingEntry(8719, "prod"), new MappingEntry(8721, "sum"), new MappingEntry(8722, "minus"), new MappingEntry(8727, "lowast"), new MappingEntry(8730, "radic"), new MappingEntry(8733, "prop"), new MappingEntry(8734, "infin"), new MappingEntry(8736, "ang"), new MappingEntry(8743, "and"), new MappingEntry(8744, "or"), new MappingEntry(8745, "cap"), new MappingEntry(8746, "cup"), new MappingEntry(8747, "int"), new MappingEntry(8756, "there4"), new MappingEntry(8764, "sim"), new MappingEntry(8773, "cong"), new MappingEntry(8776, "asymp"), new MappingEntry(8800, "ne"), new MappingEntry(8801, "equiv"), new MappingEntry(8804, "le"), new MappingEntry(8805, "ge"), new MappingEntry(8834, "sub"), new MappingEntry(8835, "sup"), new MappingEntry(8836, "nsub"), new MappingEntry(8838, "sube"), new MappingEntry(8839, "supe"), new MappingEntry(8853, "oplus"), new MappingEntry(8855, "otimes"), new MappingEntry(8869, "perp"), new MappingEntry(8901, "sdot"), new MappingEntry(8968, "lceil"), new MappingEntry(8969, "rceil"), new MappingEntry(8970, "lfloor"), new MappingEntry(8971, "rfloor"), new MappingEntry(9001, "lang"), new MappingEntry(9002, "rang"), new MappingEntry(9674, "loz"), new MappingEntry(9824, "spades"), new MappingEntry(9827, "clubs"), new MappingEntry(9829, "hearts"), new MappingEntry(9830, "diams")};

    public HTMLEncoder(IntAcceptor<? extends R> downstream) {
        super(downstream);
    }

    @Override
    public void acceptInt(int value) {
        if (value == 34) {
            this.emit("&quot;");
        } else if (value == 38) {
            this.emit("&amp;");
        } else if (value == 60) {
            this.emit("&lt;");
        } else if (value == 62) {
            this.emit("&gt;");
        } else if (value >= 32 && value < 127) {
            this.emit(value);
        } else if (value >= 160 && value <= 255) {
            this.emit(38);
            this.emit(baseEntities[value - 160]);
            this.emit(59);
        } else {
            int hi = mappedEntities.length;
            if (value >= mappedEntities[0].getCodePoint() && value <= mappedEntities[hi - 1].getCodePoint()) {
                int lo = 0;
                while (lo < hi) {
                    int mid = lo + hi >>> 1;
                    MappingEntry entry = mappedEntities[mid];
                    int entryCodePoint = entry.getCodePoint();
                    if (value == entryCodePoint) {
                        this.emit(38);
                        this.emit(entry.getString());
                        this.emit(59);
                        return;
                    }
                    if (value < entryCodePoint) {
                        hi = mid;
                        continue;
                    }
                    lo = mid + 1;
                }
            }
            this.emit("&#x");
            this.emitHex(value);
            this.emit(59);
        }
    }
}

