/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline;

import io.jstuff.pipeline.Acceptor;
import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.util.IntOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class Pipelines {
    public static <R> R process(Reader reader, IntAcceptor<R> downstream) throws IOException {
        int i;
        do {
            i = reader.read();
            downstream.accept(i);
        } while (i >= 0);
        return downstream.getResult();
    }

    public static <R> R process(InputStream inputStream, IntAcceptor<R> downstream) throws IOException {
        int i;
        do {
            i = inputStream.read();
            downstream.accept(i);
        } while (i >= 0);
        return downstream.getResult();
    }

    public static <R> R process(File file, IntAcceptor<R> downstream) throws IOException {
        return Pipelines.process(new FileInputStream(file), downstream);
    }

    public static <A, R> R process(Iterable<A> iterable, Acceptor<A, R> downstream) {
        for (A item : iterable) {
            downstream.accept(item);
        }
        downstream.safeClose();
        return downstream.getResult();
    }

    public static void acceptInt(IntAcceptor<?> acceptor, int i) {
        IntOutput.outputInt((int)i, acceptor);
    }
}

