/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.AbstractLogger;
import io.jstuff.log.Level;
import io.jstuff.log.LogAppender;
import io.jstuff.log.LogFormatter;
import io.jstuff.log.LogListener;
import java.time.Clock;
import java.time.Instant;
import java.util.function.Supplier;

public class FormattingLogger<F extends LogFormatter, A extends LogAppender<F>>
extends AbstractLogger {
    private final A appender;

    FormattingLogger(String name, A appender, Level level, Clock clock) {
        super(name, level, clock);
        this.appender = appender;
    }

    public A getAppender() {
        return this.appender;
    }

    public F getFormatter() {
        return this.appender.getFormatter();
    }

    public void log(Level level, Supplier<Object> messageSupplier) {
        if (this.isEnabled(level)) {
            this.outputLog(level, messageSupplier.get(), null);
        }
    }

    public void log(Instant time, Level level, Supplier<Object> messageSupplier) {
        if (this.isEnabled(level)) {
            this.outputLog(time, level, messageSupplier.get(), null);
        }
    }

    @Override
    protected void outputLog(Level level, Object message, Throwable throwable) {
        this.outputLog(Instant.now(this.getClock()), level, message, throwable);
    }

    @Override
    protected void outputLog(Instant time, Level level, Object message, Throwable throwable) {
        if (LogListener.present()) {
            LogListener.invokeAll(time, this, level, message, throwable);
        }
        this.appender.output(time, this, level, message, throwable);
    }
}

