/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.Level;
import io.jstuff.log.LoggerFactory;
import java.time.Clock;
import java.time.Instant;
import java.util.function.Supplier;

public interface Logger {
    public String getName();

    default public Level getLevel() {
        return Level.INFO;
    }

    default public void setLevel(Level level) {
    }

    default public Clock getClock() {
        return LoggerFactory.systemClock;
    }

    default public void setClock(Clock clock) {
    }

    public void trace(Object var1);

    default public void trace(Instant time, Object message) {
        this.trace(message);
    }

    public void debug(Object var1);

    default public void debug(Instant time, Object message) {
        this.debug(message);
    }

    public void info(Object var1);

    default public void info(Instant time, Object message) {
        this.info(message);
    }

    public void warn(Object var1);

    default public void warn(Instant time, Object message) {
        this.warn(message);
    }

    public void error(Object var1);

    default public void error(Instant time, Object message) {
        this.error(message);
    }

    public void error(Throwable var1, Object var2);

    default public void error(Instant time, Throwable throwable, Object message) {
        this.error(throwable, message);
    }

    default public boolean isTraceEnabled() {
        return this.getLevel().isEnabled(Level.TRACE);
    }

    default public boolean isDebugEnabled() {
        return this.getLevel().isEnabled(Level.DEBUG);
    }

    default public boolean isInfoEnabled() {
        return this.getLevel().isEnabled(Level.INFO);
    }

    default public boolean isWarnEnabled() {
        return this.getLevel().isEnabled(Level.WARN);
    }

    default public boolean isErrorEnabled() {
        return this.getLevel().isEnabled(Level.ERROR);
    }

    default public boolean isEnabled(Level level) {
        return this.getLevel().isEnabled(level);
    }

    default public void trace(Supplier<Object> messageSupplier) {
        if (this.isTraceEnabled()) {
            this.trace(messageSupplier.get());
        }
    }

    default public void trace(Instant time, Supplier<Object> messageSupplier) {
        if (this.isTraceEnabled()) {
            this.trace(time, messageSupplier.get());
        }
    }

    default public void debug(Supplier<Object> messageSupplier) {
        if (this.isDebugEnabled()) {
            this.debug(messageSupplier.get());
        }
    }

    default public void debug(Instant time, Supplier<Object> messageSupplier) {
        if (this.isDebugEnabled()) {
            this.debug(time, messageSupplier.get());
        }
    }

    default public void info(Supplier<Object> messageSupplier) {
        if (this.isInfoEnabled()) {
            this.info(messageSupplier.get());
        }
    }

    default public void info(Instant time, Supplier<Object> messageSupplier) {
        if (this.isInfoEnabled()) {
            this.info(time, messageSupplier.get());
        }
    }

    default public void warn(Supplier<Object> messageSupplier) {
        if (this.isWarnEnabled()) {
            this.warn(messageSupplier.get());
        }
    }

    default public void warn(Instant time, Supplier<Object> messageSupplier) {
        if (this.isWarnEnabled()) {
            this.warn(time, messageSupplier.get());
        }
    }

    default public void error(Supplier<Object> messageSupplier) {
        if (this.isErrorEnabled()) {
            this.error(messageSupplier.get());
        }
    }

    default public void error(Instant time, Supplier<Object> messageSupplier) {
        if (this.isErrorEnabled()) {
            this.error(time, messageSupplier.get());
        }
    }

    default public void error(Throwable throwable, Supplier<Object> messageSupplier) {
        if (this.isErrorEnabled()) {
            this.error(throwable, messageSupplier.get());
        }
    }

    default public void error(Instant time, Throwable throwable, Supplier<Object> messageSupplier) {
        if (this.isErrorEnabled()) {
            this.error(time, throwable, messageSupplier.get());
        }
    }

    default public void log(Level level, Object message) {
        switch (level) {
            case TRACE: {
                this.trace(message);
                break;
            }
            case DEBUG: {
                this.debug(message);
                break;
            }
            case INFO: {
                this.info(message);
                break;
            }
            case WARN: {
                this.warn(message);
                break;
            }
            case ERROR: {
                this.error(message);
            }
        }
    }

    default public void log(Instant time, Level level, Object message) {
        switch (level) {
            case TRACE: {
                this.trace(time, message);
                break;
            }
            case DEBUG: {
                this.debug(time, message);
                break;
            }
            case INFO: {
                this.info(time, message);
                break;
            }
            case WARN: {
                this.warn(time, message);
                break;
            }
            case ERROR: {
                this.error(time, message);
            }
        }
    }

    default public void log(Level level, Supplier<Object> messageSupplier) {
        switch (level) {
            case TRACE: {
                this.trace(messageSupplier);
                break;
            }
            case DEBUG: {
                this.debug(messageSupplier);
                break;
            }
            case INFO: {
                this.info(messageSupplier);
                break;
            }
            case WARN: {
                this.warn(messageSupplier);
                break;
            }
            case ERROR: {
                this.error(messageSupplier);
            }
        }
    }

    default public void log(Instant time, Level level, Supplier<Object> messageSupplier) {
        switch (level) {
            case TRACE: {
                this.trace(time, messageSupplier);
                break;
            }
            case DEBUG: {
                this.debug(time, messageSupplier);
                break;
            }
            case INFO: {
                this.info(time, messageSupplier);
                break;
            }
            case WARN: {
                this.warn(time, messageSupplier);
                break;
            }
            case ERROR: {
                this.error(time, messageSupplier);
            }
        }
    }
}

