/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.json;

import io.jstuff.text.TextMatcher;
import io.jstuff.util.IntOutput;
import java.io.IOException;
import java.util.function.IntConsumer;

public class JSONFunctions {
    public static final String UNTERMINATED_STRING = "Unterminated JSON string";
    public static final String ILLEGAL_CHAR = "Illegal character in JSON string";
    public static final String ILLEGAL_UNICODE_SEQUENCE = "Illegal Unicode sequence in JSON string";
    public static final String ILLEGAL_ESCAPE_SEQUENCE = "Illegal escape sequence in JSON string";

    public static void appendString(Appendable a, CharSequence cs, boolean includeNonASCII) throws IOException {
        a.append('\"');
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            JSONFunctions.appendChar(a, cs.charAt(i), includeNonASCII);
        }
        a.append('\"');
    }

    public static void outputString(CharSequence cs, boolean includeNonASCII, IntConsumer consumer) {
        consumer.accept(34);
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            JSONFunctions.outputChar(cs.charAt(i), includeNonASCII, consumer);
        }
        consumer.accept(34);
    }

    public static String escapeString(CharSequence cs, boolean includeNonASCII) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONFunctions.appendString(sb, cs, includeNonASCII);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String escapeStringUnquoted(CharSequence cs, boolean includeNonASCII) {
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            char ch = cs.charAt(i);
            if (ch >= ' ' && ch < '\u007f' && ch != '\"' && ch != '\\') continue;
            try {
                StringBuilder sb = new StringBuilder();
                if (i > 0) {
                    sb.append(cs, 0, i);
                }
                while (true) {
                    JSONFunctions.appendChar(sb, ch, includeNonASCII);
                    if (++i >= n) break;
                    ch = cs.charAt(i);
                }
                return sb.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return cs.toString();
    }

    public static String escapeStringUnquoted(CharSequence cs) {
        return JSONFunctions.escapeStringUnquoted(cs, false);
    }

    public static void appendChar(Appendable a, char ch, boolean includeNonASCII) throws IOException {
        if (ch == '\"' || ch == '\\') {
            a.append('\\');
            a.append(ch);
        } else if (ch == '\b') {
            a.append("\\b");
        } else if (ch == '\f') {
            a.append("\\f");
        } else if (ch == '\n') {
            a.append("\\n");
        } else if (ch == '\r') {
            a.append("\\r");
        } else if (ch == '\t') {
            a.append("\\t");
        } else if (ch < ' ' || ch >= '\u007f' && ch < '\u00a0' || ch >= '\u00a0' && !includeNonASCII) {
            a.append("\\u");
            IntOutput.append4HexLC((Appendable)a, (int)ch);
        } else {
            a.append(ch);
        }
    }

    public static void outputChar(char ch, boolean includeNonASCII, IntConsumer consumer) {
        if (ch == '\"' || ch == '\\') {
            consumer.accept(92);
            consumer.accept(ch);
        } else if (ch == '\b') {
            consumer.accept(92);
            consumer.accept(98);
        } else if (ch == '\f') {
            consumer.accept(92);
            consumer.accept(102);
        } else if (ch == '\n') {
            consumer.accept(92);
            consumer.accept(110);
        } else if (ch == '\r') {
            consumer.accept(92);
            consumer.accept(114);
        } else if (ch == '\t') {
            consumer.accept(92);
            consumer.accept(116);
        } else if (ch < ' ' || ch >= '\u007f' && ch < '\u00a0' || ch >= '\u00a0' && !includeNonASCII) {
            consumer.accept(92);
            consumer.accept(117);
            IntOutput.output4HexLC((int)ch, (IntConsumer)consumer);
        } else {
            consumer.accept(ch);
        }
    }

    public static String displayString(String str, int maxChars) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONFunctions.appendDisplayString(sb, str, maxChars);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void appendDisplayString(Appendable a, String str, int maxChars) throws IOException {
        a.append('\"');
        int i = 0;
        int n = str.length();
        if (maxChars > 7 && n > maxChars) {
            int m = maxChars - 4 >> 1;
            while (i < m) {
                JSONFunctions.appendChar(a, str.charAt(i++), true);
            }
            a.append(" ... ");
            i = n - (maxChars - 5 >> 1);
        }
        while (i < n) {
            JSONFunctions.appendChar(a, str.charAt(i++), true);
        }
        a.append('\"');
    }

    public static String parseString(TextMatcher tm) {
        int start;
        block28: {
            char ch;
            start = tm.getIndex();
            do {
                if (tm.isAtEnd()) {
                    throw new IllegalArgumentException(UNTERMINATED_STRING);
                }
                ch = tm.nextChar();
                if (ch == '\"') {
                    return tm.getString(start, tm.getStart());
                }
                if (ch == '\\') break block28;
            } while (ch >= ' ');
            throw new IllegalArgumentException(ILLEGAL_CHAR);
        }
        StringBuilder sb = new StringBuilder();
        tm.appendSubstringTo(sb, start, tm.getStart());
        block1: while (true) {
            if (tm.isAtEnd()) {
                throw new IllegalArgumentException(UNTERMINATED_STRING);
            }
            char ch = tm.nextChar();
            if (ch == '\"') {
                sb.append('\"');
            } else if (ch == '\\') {
                sb.append('\\');
            } else if (ch == '/') {
                sb.append('/');
            } else if (ch == 'b') {
                sb.append('\b');
            } else if (ch == 'f') {
                sb.append('\f');
            } else if (ch == 'n') {
                sb.append('\n');
            } else if (ch == 'r') {
                sb.append('\r');
            } else if (ch == 't') {
                sb.append('\t');
            } else if (ch == 'u') {
                if (!tm.matchHex(4, 4)) {
                    throw new IllegalArgumentException(ILLEGAL_UNICODE_SEQUENCE);
                }
                sb.append((char)tm.getResultHexInt());
            } else {
                throw new IllegalArgumentException(ILLEGAL_ESCAPE_SEQUENCE);
            }
            while (true) {
                if (tm.isAtEnd()) {
                    throw new IllegalArgumentException(UNTERMINATED_STRING);
                }
                ch = tm.nextChar();
                if (ch == '\"') {
                    return sb.toString();
                }
                if (ch == '\\') continue block1;
                if (ch < ' ') {
                    throw new IllegalArgumentException(ILLEGAL_CHAR);
                }
                sb.append(ch);
            }
            break;
        }
    }

    public static boolean isSpaceCharacter(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r';
    }
}

