/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.util;

import io.jstuff.util.ImmutableSet;
import io.jstuff.util.MiniSet0;
import io.jstuff.util.MiniSet1;
import io.jstuff.util.MiniSet2;
import io.jstuff.util.MiniSet3;
import io.jstuff.util.MiniSet4;
import io.jstuff.util.MiniSet5;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public abstract class MiniSet<T>
implements Set<T> {
    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object item : c) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set otherSet = (Set)other;
        if (this.size() != otherSet.size()) {
            return false;
        }
        for (Object item : this) {
            if (otherSet.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (Object item : this) {
            result += Objects.hashCode(item);
        }
        return result;
    }

    public String toString() {
        if (this.size() == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        for (Object item : this) {
            if (i++ > 0) {
                sb.append(',').append(' ');
            }
            sb.append(this.stringOf(item));
        }
        sb.append(']');
        return sb.toString();
    }

    protected String stringOf(Object obj) {
        return obj == this ? "(this Collection)" : String.valueOf(obj);
    }

    public static <TT> MiniSet<TT> of() {
        return MiniSet0.instance;
    }

    public static <TT> MiniSet<TT> of(TT value) {
        return new MiniSet1<TT>(value);
    }

    public static <TT> MiniSet<TT> of(TT value0, TT value1) {
        return new MiniSet2<TT>(value0, value1);
    }

    public static <TT> MiniSet<TT> of(TT value0, TT value1, TT value2) {
        return new MiniSet3<TT>(value0, value1, value2);
    }

    public static <TT> MiniSet<TT> of(TT value0, TT value1, TT value2, TT value3) {
        return new MiniSet4<TT>(value0, value1, value2, value3);
    }

    public static <TT> MiniSet<TT> of(TT value0, TT value1, TT value2, TT value3, TT value4) {
        return new MiniSet5<TT>(value0, value1, value2, value3, value4);
    }

    @SafeVarargs
    public static <TT> Set<TT> of(TT ... values) {
        int n = values.length;
        if (n == 0) {
            return MiniSet0.instance;
        }
        if (n == 1) {
            return new MiniSet1<TT>(values[0]);
        }
        if (n == 2) {
            return new MiniSet2<TT>(values[0], values[1]);
        }
        if (n == 3) {
            return new MiniSet3<TT>(values[0], values[1], values[2]);
        }
        if (n == 4) {
            return new MiniSet4<TT>(values[0], values[1], values[2], values[3]);
        }
        if (n == 5) {
            return new MiniSet5<TT>(values[0], values[1], values[2], values[3], values[4]);
        }
        return new ImmutableSet<TT>(Arrays.copyOf(values, n));
    }
}

