/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.util;

import io.jstuff.util.ImmutableMap;
import io.jstuff.util.ImmutableMapEntry;
import io.jstuff.util.MiniMap0;
import io.jstuff.util.MiniMap1;
import io.jstuff.util.MiniMap2;
import io.jstuff.util.MiniMap3;
import java.util.Map;
import java.util.Objects;

public abstract class MiniMap<K, V>
implements Map<K, V> {
    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map otherMap = (Map)other;
        if (this.size() != otherMap.size()) {
            return false;
        }
        for (Map.Entry entry : this.entrySet()) {
            if (Objects.equals(otherMap.get(entry.getKey()), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (Map.Entry entry : this.entrySet()) {
            result += entry.hashCode();
        }
        return result;
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int i = 0;
        for (Map.Entry entry : this.entrySet()) {
            if (i++ > 0) {
                sb.append(',').append(' ');
            }
            sb.append(this.stringOf(entry.getKey()));
            sb.append('=');
            sb.append(this.stringOf(entry.getValue()));
        }
        sb.append('}');
        return sb.toString();
    }

    protected String stringOf(Object obj) {
        return obj == this ? "(this Map)" : String.valueOf(obj);
    }

    public static <KK, VV> ImmutableMapEntry<KK, VV> entry(KK key, VV value) {
        return new ImmutableMapEntry<KK, VV>(key, value);
    }

    public static <KK, VV> Map<KK, VV> map(KK key, VV value) {
        return new MiniMap1<KK, VV>(key, value);
    }

    public static <KK, VV> Map<KK, VV> map(KK key0, VV value0, KK key1, VV value1) {
        return new MiniMap2<KK, VV>(key0, value0, key1, value1);
    }

    public static <KK, VV> Map<KK, VV> map(KK key0, VV value0, KK key1, VV value1, KK key2, VV value2) {
        return new MiniMap3<KK, VV>(key0, value0, key1, value1, key2, value2);
    }

    public static <KK, VV> Map<KK, VV> of() {
        return MiniMap0.instance;
    }

    public static <KK, VV> Map<KK, VV> of(Map.Entry<KK, VV> entry) {
        return new MiniMap1<KK, VV>(entry.getKey(), entry.getValue());
    }

    public static <KK, VV> Map<KK, VV> of(Map.Entry<KK, VV> entry0, Map.Entry<KK, VV> entry1) {
        return new MiniMap2<KK, VV>(entry0.getKey(), entry0.getValue(), entry1.getKey(), entry1.getValue());
    }

    public static <KK, VV> Map<KK, VV> of(Map.Entry<KK, VV> entry0, Map.Entry<KK, VV> entry1, Map.Entry<KK, VV> entry2) {
        return new MiniMap3<KK, VV>(entry0.getKey(), entry0.getValue(), entry1.getKey(), entry1.getValue(), entry2.getKey(), entry2.getValue());
    }

    @SafeVarargs
    public static <KK, VV> Map<KK, VV> of(Map.Entry<KK, VV> ... entries) {
        int n = entries.length;
        if (n == 0) {
            return MiniMap0.instance;
        }
        if (n == 1) {
            Map.Entry<KK, VV> entry0 = entries[0];
            return new MiniMap1<KK, VV>(entry0.getKey(), entry0.getValue());
        }
        if (n == 2) {
            Map.Entry<KK, VV> entry0 = entries[0];
            Map.Entry<KK, VV> entry1 = entries[1];
            return new MiniMap2<KK, VV>(entry0.getKey(), entry0.getValue(), entry1.getKey(), entry1.getValue());
        }
        if (n == 3) {
            Map.Entry<KK, VV> entry0 = entries[0];
            Map.Entry<KK, VV> entry1 = entries[1];
            Map.Entry<KK, VV> entry2 = entries[2];
            return new MiniMap3<KK, VV>(entry0.getKey(), entry0.getValue(), entry1.getKey(), entry1.getValue(), entry2.getKey(), entry2.getValue());
        }
        ImmutableMapEntry<KK, VV>[] array = ImmutableMap.createArray(n);
        for (int i = 0; i < n; ++i) {
            array[i] = ImmutableMap.entry(entries[i].getKey(), entries[i].getValue());
        }
        return new ImmutableMap(array);
    }
}

