/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.util;

import java.util.Map;
import java.util.Objects;

public class ImmutableMapEntry<K, V>
implements Map.Entry<K, V> {
    private final K key;
    private final V value;

    public ImmutableMapEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Map.Entry)) {
            return false;
        }
        Map.Entry otherMapEntry = (Map.Entry)other;
        return Objects.equals(this.key, otherMapEntry.getKey()) && Objects.equals(this.value, otherMapEntry.getValue());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
    }

    public String toString() {
        return String.valueOf(this.key) + '=' + this.value;
    }
}

