/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.crypto;

import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.impl.crypto.SignatureProvider;
import io.jsonwebtoken.lang.Assert;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

abstract class RsaProvider
extends SignatureProvider {
    protected RsaProvider(SignatureAlgorithm alg, Key key) {
        super(alg, key);
        Assert.isTrue(alg.isRsa(), "SignatureAlgorithm must be an RSASSA or RSASSA-PSS algorithm.");
    }

    protected Signature createSignatureInstance() {
        Signature sig = this.newSignatureInstance();
        if (this.alg.name().startsWith("PS")) {
            int saltLength;
            MGF1ParameterSpec paramSpec;
            switch (this.alg) {
                case PS256: {
                    paramSpec = MGF1ParameterSpec.SHA256;
                    saltLength = 32;
                    break;
                }
                case PS384: {
                    paramSpec = MGF1ParameterSpec.SHA384;
                    saltLength = 48;
                    break;
                }
                case PS512: {
                    paramSpec = MGF1ParameterSpec.SHA512;
                    saltLength = 64;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported RSASSA-PSS algorithm: " + (Object)((Object)this.alg));
                }
            }
            PSSParameterSpec pssParamSpec = new PSSParameterSpec(paramSpec.getDigestAlgorithm(), "MGF1", paramSpec, saltLength, 1);
            this.setParameter(sig, pssParamSpec);
        }
        return sig;
    }

    protected Signature newSignatureInstance() {
        try {
            return Signature.getInstance(this.alg.getJcaName());
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "Unavailable RSA Signature algorithm.";
            if (!this.alg.isJdkStandard()) {
                msg = msg + " This is not a standard JDK algorithm. Try including BouncyCastle in the runtime classpath.";
            }
            throw new SignatureException(msg, e);
        }
    }

    protected void setParameter(Signature sig, PSSParameterSpec spec) {
        try {
            sig.setParameter(spec);
        }
        catch (InvalidAlgorithmParameterException e) {
            String msg = "Unsupported RSASSA-PSS parameter '" + spec + "': " + e.getMessage();
            throw new SignatureException(msg, e);
        }
    }
}

