/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.orgjson.io;

import io.jsonwebtoken.io.AbstractDeserializer;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class OrgJsonDeserializer
extends AbstractDeserializer<Object> {
    protected Object doDeserialize(Reader reader) {
        return this.parse(reader);
    }

    private Object parse(Reader reader) throws JSONException {
        JSONTokener tokener = new JSONTokener(reader);
        char c = tokener.nextClean();
        tokener.back();
        if (c == '{') {
            JSONObject o = new JSONObject(tokener);
            return this.toMap(o);
        }
        if (c == '[') {
            JSONArray a = new JSONArray(tokener);
            return this.toList(a);
        }
        Object value = tokener.nextValue();
        return this.convertIfNecessary(value);
    }

    private Map<String, Object> toMap(JSONObject o) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Iterator iterator = o.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = o.get(key);
            value = this.convertIfNecessary(value);
            map.put(key, value);
        }
        return map;
    }

    private List<Object> toList(JSONArray a) {
        int length = a.length();
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object value = a.get(i);
            value = this.convertIfNecessary(value);
            list.add(value);
        }
        return list;
    }

    private Object convertIfNecessary(Object v) {
        List<Object> value = v;
        if (JSONObject.NULL.equals(value)) {
            value = null;
        } else if (value instanceof JSONArray) {
            value = this.toList((JSONArray)value);
        } else if (value instanceof JSONObject) {
            value = this.toMap((JSONObject)value);
        }
        return value;
    }
}

