/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.AddOpens;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.OptionalMethodInvoker;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.impl.security.PasswordSpec;
import io.jsonwebtoken.impl.security.ProvidedPrivateKeyBuilder;
import io.jsonwebtoken.impl.security.ProvidedSecretKeyBuilder;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeySupplier;
import io.jsonwebtoken.security.Password;
import io.jsonwebtoken.security.PrivateKeyBuilder;
import io.jsonwebtoken.security.SecretKeyBuilder;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;

public final class KeysBridge {
    private static final String SUNPKCS11_GENERIC_SECRET_CLASSNAME = "sun.security.pkcs11.P11Key$P11SecretKey";
    private static final String SUNPKCS11_GENERIC_SECRET_ALGNAME = "Generic Secret";
    private static final String SUN_KEYUTIL_CLASSNAME = "sun.security.util.KeyUtil";
    private static final OptionalMethodInvoker<Key, Integer> SUN_KEYSIZE = new OptionalMethodInvoker("sun.security.util.KeyUtil", "getKeySize", Key.class, true);
    private static final String SUN_KEYUTIL_ERR = "Unexpected sun.security.util.KeyUtil invocation error.";

    private KeysBridge() {
    }

    public static Password password(char[] password) {
        return new PasswordSpec(password);
    }

    public static SecretKeyBuilder builder(SecretKey key) {
        return new ProvidedSecretKeyBuilder(key);
    }

    public static PrivateKeyBuilder builder(PrivateKey key) {
        return new ProvidedPrivateKeyBuilder(key);
    }

    public static <K extends Key> K root(K key) {
        return key instanceof KeySupplier ? KeysBridge.root((KeySupplier)key) : key;
    }

    public static <K extends Key> K root(KeySupplier<K> supplier) {
        Assert.notNull(supplier, (String)"KeySupplier canot be null.");
        return (K)((Key)Assert.notNull((Object)KeysBridge.root(supplier.getKey()), (String)"KeySupplier key cannot be null."));
    }

    public static String findAlgorithm(Key key) {
        return key != null ? Strings.clean((String)key.getAlgorithm()) : null;
    }

    public static byte[] findEncoded(Key key) {
        Assert.notNull((Object)key, (String)"Key cannot be null.");
        byte[] encoded = null;
        try {
            encoded = key.getEncoded();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return encoded;
    }

    public static boolean isSunPkcs11GenericSecret(Key key) {
        return key instanceof SecretKey && key.getClass().getName().equals(SUNPKCS11_GENERIC_SECRET_CLASSNAME) && SUNPKCS11_GENERIC_SECRET_ALGNAME.equals(key.getAlgorithm());
    }

    public static int findBitLength(Key key) {
        Integer retval = (Integer)SUN_KEYSIZE.apply(key);
        int bitlen = (Integer)Assert.stateNotNull((Object)retval, (String)SUN_KEYUTIL_ERR);
        if (bitlen > 0 && KeysBridge.isSunPkcs11GenericSecret(key)) {
            bitlen *= 8;
        }
        if (bitlen > 0) {
            return bitlen;
        }
        EdwardsCurve curve = EdwardsCurve.findByKey(key);
        if (curve != null) {
            bitlen = curve.getKeyBitLength();
        }
        return bitlen;
    }

    public static byte[] getEncoded(Key key) {
        byte[] encoded;
        Assert.notNull((Object)key, (String)"Key cannot be null.");
        try {
            encoded = key.getEncoded();
        }
        catch (Throwable t) {
            String msg = "Cannot obtain required encoded bytes from key [" + KeysBridge.toString(key) + "]: " + t.getMessage();
            throw new InvalidKeyException(msg, t);
        }
        if (Bytes.isEmpty(encoded)) {
            String msg = "Missing required encoded bytes for key [" + KeysBridge.toString(key) + "].";
            throw new InvalidKeyException(msg);
        }
        return encoded;
    }

    public static String toString(Key key) {
        if (key == null) {
            return "null";
        }
        if (key instanceof PublicKey) {
            return key.toString();
        }
        return "class: " + key.getClass().getName() + ", algorithm: " + key.getAlgorithm() + ", format: " + key.getFormat();
    }

    static {
        AddOpens.open("java.base", "sun.security.util");
    }
}

