/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.routing.DelayableImmutableMessage;
import io.joynr.messaging.routing.MulticastAddressCalculator;
import io.joynr.messaging.routing.MulticastReceiverRegistry;
import io.joynr.messaging.routing.RoutingTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import joynr.ImmutableMessage;
import joynr.Message;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressManager {
    private static final Logger logger = LoggerFactory.getLogger(AddressManager.class);
    public static final String multicastAddressCalculatorParticipantId = "joynr.internal.multicastAddressCalculatorParticipantId";
    private final MulticastReceiverRegistry multicastReceiversRegistry;
    private RoutingTable routingTable;
    private MulticastAddressCalculator multicastAddressCalculator;

    @Inject
    public AddressManager(RoutingTable routingTable, Optional<MulticastAddressCalculator> multicastAddressCalculator, MulticastReceiverRegistry multicastReceiverRegistry) {
        logger.trace("Initialised with routingTable: {}, multicastAddressCalculator: {}, multicastReceiverRegistry: {}", new Object[]{routingTable, multicastAddressCalculator.orElse(null), multicastReceiverRegistry});
        this.routingTable = routingTable;
        this.multicastReceiversRegistry = multicastReceiverRegistry;
        this.multicastAddressCalculator = multicastAddressCalculator.orElse(null);
    }

    public Map<Address, Set<String>> getParticipantIdMap(ImmutableMessage message) {
        HashMap<Address, Set<String>> result = new HashMap<Address, Set<String>>();
        if (Message.MessageType.VALUE_MESSAGE_TYPE_MULTICAST.equals((Object)message.getType())) {
            Set<String> localReceivers = this.getLocalMulticastReceiversFromRegistry(message);
            for (String r : localReceivers) {
                Address address = this.routingTable.get(r);
                if (address == null) {
                    logger.error("No address found for multicast receiver {} for {}", (Object)r, (Object)message.getTrackingInfo());
                    continue;
                }
                Set<String> receiverSet = result.get(address);
                if (receiverSet == null) {
                    receiverSet = new HashSet<String>();
                    result.put(address, receiverSet);
                }
                receiverSet.add(r);
            }
            if (!message.isReceivedFromGlobal() && this.multicastAddressCalculator != null) {
                if (this.multicastAddressCalculator.createsGlobalTransportAddresses()) {
                    if (this.isProviderGloballyVisible(message.getSender())) {
                        this.addReceiversFromAddressCalculator(message, result);
                    }
                } else {
                    this.addReceiversFromAddressCalculator(message, result);
                }
            }
        } else {
            String toParticipantId = message.getRecipient();
            if (toParticipantId != null) {
                result.put(new Address(), Set.of(toParticipantId));
            }
        }
        logger.trace("Found the following recipients for {}: {}", (Object)message, result);
        return result;
    }

    public Optional<Address> getAddressForDelayableImmutableMessage(DelayableImmutableMessage message) {
        Map<String, String> customHeader = message.getMessage().getCustomHeaders();
        String gbidVal = customHeader.get("gb");
        Address address = null;
        Set<String> recipients = message.getRecipients();
        for (String recipient : recipients) {
            if (address != null) break;
            if (recipient.startsWith(multicastAddressCalculatorParticipantId)) {
                address = this.determineAddressFromMulticastAddressCalculator(message, recipient);
                continue;
            }
            if (gbidVal == null) {
                address = this.routingTable.get(recipient);
                continue;
            }
            address = this.routingTable.get(recipient, gbidVal);
        }
        return address == null ? Optional.empty() : Optional.of(address);
    }

    private Address determineAddressFromMulticastAddressCalculator(DelayableImmutableMessage message, String recipient) {
        Address address = null;
        Set<Address> addressSet = this.multicastAddressCalculator.calculate(message.getMessage());
        if (addressSet.size() <= 1) {
            Iterator<Address> iterator = addressSet.iterator();
            while (iterator.hasNext()) {
                Address calculatedAddress;
                address = calculatedAddress = iterator.next();
            }
        } else {
            for (Address calculatedAddress : addressSet) {
                MqttAddress mqttAddress = (MqttAddress)calculatedAddress;
                String brokerUri = mqttAddress.getBrokerUri();
                if (!recipient.equals("joynr.internal.multicastAddressCalculatorParticipantId_" + brokerUri)) continue;
                address = calculatedAddress;
                break;
            }
        }
        return address;
    }

    private boolean isProviderGloballyVisible(String participantId) {
        boolean isGloballyVisible = false;
        try {
            isGloballyVisible = this.routingTable.getIsGloballyVisible(participantId);
        }
        catch (JoynrRuntimeException e) {
            logger.error("No routing entry found for Multicast Provider {}. The message will not be published globally.", (Object)participantId);
        }
        return isGloballyVisible;
    }

    private void addReceiversFromAddressCalculator(ImmutableMessage message, HashMap<Address, Set<String>> result) {
        Set<Address> calculatedAddresses = this.multicastAddressCalculator.calculate(message);
        if (calculatedAddresses.size() == 1) {
            result.put(calculatedAddresses.iterator().next(), Set.of(multicastAddressCalculatorParticipantId));
        } else {
            for (Address address : calculatedAddresses) {
                MqttAddress mqttAddress = (MqttAddress)address;
                result.put(address, Set.of("joynr.internal.multicastAddressCalculatorParticipantId_" + mqttAddress.getBrokerUri()));
            }
        }
    }

    private Set<String> getLocalMulticastReceiversFromRegistry(ImmutableMessage message) {
        return this.multicastReceiversRegistry.getReceivers(message.getRecipient());
    }
}

