/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.joynr.dispatcher.rpc.ReflectionUtils;
import io.joynr.exceptions.JoynrIllegalStateException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import joynr.JoynrMessageType;

public class OneWayRequest
implements JoynrMessageType {
    private static final long serialVersionUID = 1L;
    private String methodName;
    private String[] paramDatatypes;
    private Object[] params;
    private String creatorUserId;
    private Map<String, Serializable> context;

    public OneWayRequest() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public OneWayRequest(String methodName, Object[] parameters, String[] parameterDatatypes) {
        if (methodName == null || methodName.trim().isEmpty()) {
            throw new JoynrIllegalStateException("Cannot create a request with a null or empty method name.");
        }
        this.methodName = methodName;
        this.paramDatatypes = parameterDatatypes;
        this.params = parameters;
    }

    public OneWayRequest(String methodName, Object[] parameters, Class<?>[] parameterDatatypes) {
        this(methodName, parameters, ReflectionUtils.toDatatypeNames((Class[])parameterDatatypes));
    }

    public String getMethodName() {
        return this.methodName;
    }

    @JsonIgnore
    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public void setCreatorUserId(String creator) {
        this.creatorUserId = creator;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public String[] getParamDatatypes() {
        return this.paramDatatypes;
    }

    @JsonIgnore
    public boolean hasParamDatatypes() {
        return this.paramDatatypes != null && this.paramDatatypes.length > 0;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Object[] getParams() {
        return this.params;
    }

    @JsonIgnore
    public boolean hasParams() {
        return this.params != null && this.params.length > 0;
    }

    @JsonIgnore
    public Map<String, Serializable> getContext() {
        return this.context;
    }

    public void setContext(Map<String, Serializable> context) {
        this.context = context;
    }

    @JsonIgnore
    public List<String> getFullyQualifiedParamDatatypes() {
        String[] names = this.getParamDatatypes();
        if (names == null) {
            return null;
        }
        String[] fullyQualifiedNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            String type;
            String typeName = names[i];
            fullyQualifiedNames[i] = type = this.fullyQualifiedNameFor(typeName);
        }
        return Arrays.asList(fullyQualifiedNames);
    }

    private String fullyQualifiedNameFor(String typeName) {
        if (typeName == null) {
            return null;
        }
        String fullyQualifiedName = null;
        fullyQualifiedName = typeName.equals("Boolean") ? Boolean.class.getCanonicalName() : (typeName.equals("Byte") ? Byte.class.getCanonicalName() : (typeName.equals("Short") ? Short.class.getCanonicalName() : (typeName.equals("Integer") ? Integer.class.getCanonicalName() : (typeName.equals("Long") ? Long.class.getCanonicalName() : (typeName.equals("Float") ? Float.class.getCanonicalName() : (typeName.equals("Double") ? Double.class.getCanonicalName() : (typeName.equals("String") ? String.class.getCanonicalName() : (typeName.equals("List") ? List.class.getCanonicalName() : typeName))))))));
        return fullyQualifiedName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + Arrays.hashCode(this.paramDatatypes);
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OneWayRequest other = (OneWayRequest)obj;
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.paramDatatypes, other.paramDatatypes)) {
            return false;
        }
        return Arrays.deepEquals(this.params, other.params);
    }

    public String toString() {
        return "OneWayRequest [methodName=" + this.methodName + ", paramDatatypes=" + Arrays.toString(this.paramDatatypes) + ", params=" + Arrays.toString(this.params) + "]";
    }
}

