/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import com.fasterxml.jackson.databind.JsonMappingException;
import io.joynr.dispatcher.rpc.ReflectionUtils;
import io.joynr.dispatcher.rpc.annotation.JoynrRpcCallback;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;

public class MethodMetaInformation {
    private final Method method;
    private JoynrRpcCallback callbackAnnotation;
    private int callbackIndex = -1;

    public MethodMetaInformation(Method method) throws JsonMappingException {
        this.method = method;
        if (method.getParameterTypes().length > 0) {
            List parameterAnnotations = ReflectionUtils.findAndMergeParameterAnnotations((Method)method);
            for (int i = 0; i < parameterAnnotations.size(); ++i) {
                List parameterAnnotation = (List)parameterAnnotations.get(i);
                if (!this.findCallbackAnnotation(parameterAnnotation)) continue;
                this.callbackIndex = i;
            }
        }
    }

    private boolean findCallbackAnnotation(List<Annotation> parameterAnnotation) {
        for (Annotation annotation : parameterAnnotation) {
            if (!(annotation instanceof JoynrRpcCallback) || this.callbackAnnotation != null) continue;
            this.callbackAnnotation = (JoynrRpcCallback)annotation;
            return true;
        }
        return false;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public Class<?>[] getClasses() {
        return this.method.getParameterTypes();
    }

    public JoynrRpcCallback getCallbackAnnotation() {
        return this.callbackAnnotation;
    }

    public int getCallbackIndex() {
        return this.callbackIndex;
    }
}

