/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import io.joynr.pubsub.SubscriptionQos;
import joynr.BroadcastFilterParameters;
import joynr.OnChangeSubscriptionQos;
import joynr.SubscriptionRequest;

public class BroadcastSubscriptionRequest
extends SubscriptionRequest {
    private static final long serialVersionUID = 1L;
    private BroadcastFilterParameters filterParameters = new BroadcastFilterParameters();

    public BroadcastSubscriptionRequest() {
    }

    public BroadcastSubscriptionRequest(String subscriptionId, String subscribedToName, BroadcastFilterParameters filterParameters, OnChangeSubscriptionQos qos) {
        super(subscriptionId, subscribedToName, (SubscriptionQos)qos);
        if (filterParameters != null) {
            this.filterParameters.setFilterParameters(filterParameters.getFilterParameters());
        }
    }

    public BroadcastFilterParameters getFilterParameters() {
        return this.filterParameters;
    }

    @Override
    public String toString() {
        return "BroadcastSubscriptionRequest [subscriptionId=" + this.subscriptionId + ",, subscribedToName=" + this.subscribedToName + ", filterParameters=" + this.filterParameters + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.filterParameters == null ? 0 : this.filterParameters.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BroadcastSubscriptionRequest other = (BroadcastSubscriptionRequest)obj;
        return !(this.filterParameters == null ? other.filterParameters != null : !this.filterParameters.equals((Object)other.filterParameters));
    }

    @Override
    public void setQos(SubscriptionQos qos) {
        if (!(qos instanceof OnChangeSubscriptionQos)) {
            throw new IllegalArgumentException("Qos of broadcast subsription is expected of type " + OnChangeSubscriptionQos.class.getSimpleName());
        }
        super.setQos(qos);
    }
}

