/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.discovery.LocalDiscoveryAggregator;
import io.joynr.dispatching.Dispatcher;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.MessagingSkeletonFactory;
import io.joynr.messaging.routing.LibJoynrMessageRouter;
import io.joynr.messaging.routing.RoutingTable;
import io.joynr.messaging.sender.LibJoynrMessageSender;
import io.joynr.proxy.ProxyBuilder;
import io.joynr.proxy.ProxyBuilderFactory;
import io.joynr.runtime.JoynrRuntimeImpl;
import joynr.system.RoutingProxy;
import joynr.system.RoutingTypes.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibjoynrRuntime
extends JoynrRuntimeImpl {
    public static final Logger logger = LoggerFactory.getLogger(LibjoynrRuntime.class);

    @Inject
    public LibjoynrRuntime(ObjectMapper objectMapper, ProxyBuilderFactory proxyBuilderFactory, Dispatcher dispatcher, MessagingSkeletonFactory messagingSkeletonFactory, LocalDiscoveryAggregator localDiscoveryAggregator, RoutingTable routingTable, @Named(value="joynr.messaging.systemservicesdomain") String systemServicesDomain, @Named(value="joynr.messaging.dispatcheraddress") Address dispatcherAddress, @Named(value="joynr.messaging.ccmessagingaddress") Address discoveryProviderAddress, final @Named(value="joynr.messaging.ccmessagingaddress") Address ccMessagingAddress, final LibJoynrMessageRouter messageRouter, final LibJoynrMessageSender messageSender, final @Named(value="joynr.messaging.routingproviderparticipantid") String parentRoutingProviderParticipantId) {
        super(objectMapper, proxyBuilderFactory, dispatcher, messagingSkeletonFactory, localDiscoveryAggregator, routingTable, systemServicesDomain, dispatcherAddress, discoveryProviderAddress);
        final ProxyBuilder<RoutingProxy> proxyBuilder = this.getProxyBuilder(systemServicesDomain, RoutingProxy.class);
        ProxyBuilder.ProxyCreatedCallback<RoutingProxy> routingProxyCreatedCallback = new ProxyBuilder.ProxyCreatedCallback<RoutingProxy>(){

            @Override
            public void onProxyCreationFinished(RoutingProxy routingProxy) {
                messageRouter.setParentRouter(routingProxy, ccMessagingAddress, parentRoutingProviderParticipantId, proxyBuilder.getParticipantId());
                messageSender.setReplyToAddress(routingProxy.getReplyToAddress());
            }

            @Override
            public void onProxyCreationError(JoynrRuntimeException error) {
                logger.error("Routing proxy creation failed: " + (Object)((Object)error));
            }
        };
        proxyBuilder.build(routingProxyCreatedCallback);
    }
}

