/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class JoynrThreadFactory
implements ThreadFactory {
    private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
    private AtomicInteger threadCount = new AtomicInteger(0);
    private String namePrefix = "joynr-";
    private boolean daemon = false;

    public JoynrThreadFactory() {
    }

    public JoynrThreadFactory(String name, boolean daemon) {
        this();
        this.namePrefix = this.namePrefix + name + "-";
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread newThread = this.defaultThreadFactory.newThread(runnable);
        newThread.setName(this.namePrefix + this.threadCount.getAndIncrement());
        newThread.setDaemon(this.daemon);
        return newThread;
    }
}

