/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.arbitration.ArbitratorFactory;
import io.joynr.capabilities.CapabilitiesRegistrar;
import io.joynr.discovery.LocalDiscoveryAggregator;
import io.joynr.dispatching.Dispatcher;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.MessagingSkeletonFactory;
import io.joynr.messaging.inprocess.InProcessAddress;
import io.joynr.messaging.inprocess.InProcessLibjoynrMessagingSkeleton;
import io.joynr.messaging.inprocess.InProcessMessagingSkeleton;
import io.joynr.messaging.routing.AddressOperation;
import io.joynr.messaging.routing.RoutingTable;
import io.joynr.proxy.Future;
import io.joynr.proxy.ProxyBuilder;
import io.joynr.proxy.ProxyBuilderFactory;
import io.joynr.runtime.JoynrRuntime;
import io.joynr.runtime.ShutdownNotifier;
import io.joynr.subtypes.JoynrType;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import joynr.BroadcastSubscriptionRequest;
import joynr.Reply;
import joynr.Request;
import joynr.SubscriptionPublication;
import joynr.SubscriptionRequest;
import joynr.SubscriptionStop;
import joynr.exceptions.ApplicationException;
import joynr.system.RoutingTypes.Address;
import joynr.types.ProviderQos;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JoynrRuntimeImpl
implements JoynrRuntime {
    private static final Logger logger = LoggerFactory.getLogger(JoynrRuntimeImpl.class);
    @Inject
    private CapabilitiesRegistrar capabilitiesRegistrar;
    private Dispatcher dispatcher;
    @Inject
    public ObjectMapper objectMapper;
    @Inject
    ShutdownNotifier shutdownNotifier;
    private final ProxyBuilderFactory proxyBuilderFactory;
    private Queue<Future<Void>> unregisterProviderQueue = new ConcurrentLinkedQueue<Future<Void>>();

    @Inject
    public JoynrRuntimeImpl(ObjectMapper objectMapper, ProxyBuilderFactory proxyBuilderFactory, Dispatcher dispatcher, MessagingSkeletonFactory messagingSkeletonFactory, LocalDiscoveryAggregator localDiscoveryAggregator, RoutingTable routingTable, @Named(value="joynr.messaging.systemservicesdomain") String systemServicesDomain, @Named(value="joynr.messaging.dispatcheraddress") Address dispatcherAddress, @Named(value="joynr.messaging.ccmessagingaddress") Address discoveryProviderAddress) {
        this.dispatcher = dispatcher;
        this.objectMapper = objectMapper;
        Reflections reflections = new Reflections("joynr", new Scanner[0]);
        Set subClasses = reflections.getSubTypesOf(JoynrType.class);
        objectMapper.registerSubtypes(subClasses.toArray(new Class[subClasses.size()]));
        Class[] messageTypes = new Class[]{Request.class, Reply.class, SubscriptionRequest.class, SubscriptionStop.class, SubscriptionPublication.class, BroadcastSubscriptionRequest.class};
        objectMapper.registerSubtypes(messageTypes);
        this.proxyBuilderFactory = proxyBuilderFactory;
        if (dispatcherAddress instanceof InProcessAddress) {
            ((InProcessAddress)dispatcherAddress).setSkeleton((InProcessMessagingSkeleton)new InProcessLibjoynrMessagingSkeleton(dispatcher));
        }
        routingTable.apply(new AddressOperation(){

            public void perform(Address address) {
                if (address instanceof InProcessAddress && ((InProcessAddress)address).getSkeleton() == null) {
                    ((InProcessAddress)address).setSkeleton((InProcessMessagingSkeleton)new InProcessLibjoynrMessagingSkeleton(JoynrRuntimeImpl.this.dispatcher));
                }
            }
        });
        if (discoveryProviderAddress instanceof InProcessAddress) {
            ((InProcessAddress)discoveryProviderAddress).setSkeleton((InProcessMessagingSkeleton)new InProcessLibjoynrMessagingSkeleton(dispatcher));
        }
        localDiscoveryAggregator.forceQueryOfDiscoveryProxy();
        ArbitratorFactory.start();
        messagingSkeletonFactory.start();
    }

    @Override
    public <T> ProxyBuilder<T> getProxyBuilder(String domain, Class<T> interfaceClass) {
        HashSet<String> domains = new HashSet<String>();
        domains.add(domain);
        return this.getProxyBuilder(domains, interfaceClass);
    }

    @Override
    public <T> ProxyBuilder<T> getProxyBuilder(Set<String> domains, Class<T> interfaceClass) {
        if (domains == null || domains.isEmpty() || domains.contains(null)) {
            throw new IllegalArgumentException("Cannot create ProxyBuilder: domain was not set");
        }
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Cannot create ProxyBuilder: interfaceClass may not be NULL");
        }
        return this.proxyBuilderFactory.get(domains, interfaceClass);
    }

    @Override
    public Future<Void> registerProvider(String domain, Object provider, ProviderQos providerQos) {
        boolean awaitGlobalRegistration = false;
        return this.capabilitiesRegistrar.registerProvider(domain, provider, providerQos, false);
    }

    @Override
    public Future<Void> registerProvider(String domain, Object provider, ProviderQos providerQos, boolean awaitGlobalRegistration) {
        return this.capabilitiesRegistrar.registerProvider(domain, provider, providerQos, awaitGlobalRegistration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterProvider(String domain, Object provider) {
        Queue<Future<Void>> queue = this.unregisterProviderQueue;
        synchronized (queue) {
            this.unregisterProviderQueue.add(this.capabilitiesRegistrar.unregisterProvider(domain, provider));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean clear) {
        logger.info("SHUTTING DOWN runtime");
        Queue<Future<Void>> queue = this.unregisterProviderQueue;
        synchronized (queue) {
            while (this.unregisterProviderQueue.peek() != null) {
                try {
                    logger.trace("unregister Provider Requests pending: " + this.unregisterProviderQueue.size());
                    Future<Void> unregisterFinished = this.unregisterProviderQueue.poll();
                    unregisterFinished.get(5000L);
                }
                catch (JoynrRuntimeException | InterruptedException | ApplicationException e) {
                    logger.error("unregister Provider failed", e);
                    break;
                }
            }
            this.shutdownNotifier.shutdown();
        }
    }
}

