/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.joynr.runtime.JoynrThreadFactory;
import io.joynr.runtime.ShutdownListener;
import io.joynr.runtime.ShutdownNotifier;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultScheduledExecutorServiceProvider
implements Provider<ScheduledExecutorService>,
ShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultScheduledExecutorServiceProvider.class);
    private static final int MQTT_THREADS = 4;
    private static final int MAX_SKELETON_THREADS = 5;
    private static final long TERMINATION_TIMEOUT = 5000L;
    private ScheduledThreadPoolExecutor scheduler;

    @Inject
    public DefaultScheduledExecutorServiceProvider(@Named(value="joynr.messaging.maximumparallelsends") int maximumParallelSends, ShutdownNotifier shutdownNotifier) {
        JoynrThreadFactory schedulerNamedThreadFactory = new JoynrThreadFactory("ScheduledExecutorService", true);
        this.scheduler = new ScheduledThreadPoolExecutor(maximumParallelSends + 5 + 4, schedulerNamedThreadFactory);
        this.scheduler.setKeepAliveTime(100L, TimeUnit.SECONDS);
        this.scheduler.allowCoreThreadTimeOut(true);
        shutdownNotifier.registerToBeShutdownAsLast((ShutdownListener)this);
    }

    public ScheduledExecutorService get() {
        return this.scheduler;
    }

    public void shutdown() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                logger.error("Message Scheduler did not shut down in time. Timed out waiting for executor service to shutdown after {}ms.", (Object)5000L);
                logger.debug("Attempting to shutdown scheduler {} forcibly.", (Object)this.scheduler);
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Message Scheduler shutdown interrupted: {}", (Object)e.getMessage());
        }
    }
}

