/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.joynr.arbitration.ArbitratorFactory;
import io.joynr.capabilities.CapabilitiesRegistrar;
import io.joynr.capabilities.CapabilitiesRegistrarImpl;
import io.joynr.capabilities.CapabilityUtils;
import io.joynr.capabilities.ParticipantIdStorage;
import io.joynr.capabilities.PropertiesFileParticipantIdStorage;
import io.joynr.capabilities.StaticCapabilitiesProvisioningModule;
import io.joynr.context.JoynrMessageScopeModule;
import io.joynr.discovery.LocalDiscoveryAggregator;
import io.joynr.dispatching.Dispatcher;
import io.joynr.dispatching.DispatcherImpl;
import io.joynr.dispatching.RequestReplyManager;
import io.joynr.dispatching.RequestReplyManagerImpl;
import io.joynr.dispatching.rpc.RpcUtils;
import io.joynr.dispatching.subscription.FileSubscriptionRequestStorage;
import io.joynr.dispatching.subscription.PublicationManager;
import io.joynr.dispatching.subscription.PublicationManagerImpl;
import io.joynr.dispatching.subscription.SubscriptionManager;
import io.joynr.dispatching.subscription.SubscriptionManagerImpl;
import io.joynr.dispatching.subscription.SubscriptionRequestStorage;
import io.joynr.exceptions.JoynrDelayMessageException;
import io.joynr.logging.JoynrAppenderManagerFactory;
import io.joynr.messaging.AbstractMiddlewareMessagingStubFactory;
import io.joynr.messaging.ConfigurableMessagingSettings;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.IMessagingStub;
import io.joynr.messaging.JoynrMessageProcessor;
import io.joynr.messaging.JsonMessageSerializerModule;
import io.joynr.messaging.MessagingSettings;
import io.joynr.messaging.NoOpRawMessagingPreprocessor;
import io.joynr.messaging.RawMessagingPreprocessor;
import io.joynr.messaging.inprocess.InProcessAddress;
import io.joynr.messaging.inprocess.InProcessLibjoynrMessagingSkeleton;
import io.joynr.messaging.inprocess.InProcessMessagingStubFactory;
import io.joynr.messaging.routing.GlobalAddressFactory;
import io.joynr.messaging.routing.InMemoryMulticastReceiverRegistry;
import io.joynr.messaging.routing.MulticastAddressCalculator;
import io.joynr.messaging.routing.MulticastReceiverRegistry;
import io.joynr.messaging.routing.RoutingTable;
import io.joynr.messaging.routing.RoutingTableImpl;
import io.joynr.proxy.ProxyBuilderFactory;
import io.joynr.proxy.ProxyBuilderFactoryImpl;
import io.joynr.proxy.ProxyInvocationHandler;
import io.joynr.proxy.ProxyInvocationHandlerFactory;
import io.joynr.proxy.ProxyInvocationHandlerImpl;
import io.joynr.runtime.DefaultScheduledExecutorServiceProvider;
import io.joynr.statusmetrics.DefaultStatusReceiver;
import io.joynr.statusmetrics.StatusReceiver;
import java.lang.annotation.Annotation;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Named;
import joynr.system.DiscoveryAsync;
import joynr.system.RoutingTypes.Address;

abstract class AbstractRuntimeModule
extends AbstractModule {
    MapBinder<Class<? extends Address>, AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address>> messagingStubFactory;
    MapBinder<Class<? extends Address>, IMessagingSkeleton> messagingSkeletonFactory;
    @SuppressWarnings(value={"URF_UNREAD_FIELD"})
    Multibinder<MulticastAddressCalculator> multicastAddressCalculators;

    AbstractRuntimeModule() {
    }

    protected void configure() {
        this.requestStaticInjection(new Class[]{CapabilityUtils.class, RpcUtils.class, ArbitratorFactory.class, JoynrDelayMessageException.class, JoynrAppenderManagerFactory.class});
        this.install((Module)new JsonMessageSerializerModule());
        this.install(new FactoryModuleBuilder().implement(ProxyInvocationHandler.class, ProxyInvocationHandlerImpl.class).build(ProxyInvocationHandlerFactory.class));
        this.install((Module)new JoynrMessageScopeModule());
        this.messagingStubFactory = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<? extends Address>>(){}, (TypeLiteral)new TypeLiteral<AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address>>(){}, (Annotation)Names.named((String)"MIDDLEWARE_MESSAGING_STUB_FACTORIES"));
        this.messagingStubFactory.addBinding(InProcessAddress.class).to(InProcessMessagingStubFactory.class);
        this.messagingSkeletonFactory = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<? extends Address>>(){}, (TypeLiteral)new TypeLiteral<IMessagingSkeleton>(){}, (Annotation)Names.named((String)"MIDDLEWARE_MESSAGING_SKELETONS"));
        this.messagingSkeletonFactory.addBinding(InProcessAddress.class).to(InProcessLibjoynrMessagingSkeleton.class);
        Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<GlobalAddressFactory<? extends Address>>(){}, (Annotation)Names.named((String)"global_address_factories"));
        Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<GlobalAddressFactory<? extends Address>>(){}, (Annotation)Names.named((String)"reply_to_address_factories"));
        this.multicastAddressCalculators = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<MulticastAddressCalculator>(){});
        this.bind(ProxyBuilderFactory.class).to(ProxyBuilderFactoryImpl.class);
        this.bind(RequestReplyManager.class).to(RequestReplyManagerImpl.class);
        this.bind(SubscriptionManager.class).to(SubscriptionManagerImpl.class);
        this.bind(PublicationManager.class).to(PublicationManagerImpl.class);
        this.bind(Dispatcher.class).to(DispatcherImpl.class);
        this.bind(LocalDiscoveryAggregator.class).in(Singleton.class);
        this.bind(DiscoveryAsync.class).to(LocalDiscoveryAggregator.class);
        this.bind(CapabilitiesRegistrar.class).to(CapabilitiesRegistrarImpl.class);
        this.bind(ParticipantIdStorage.class).to(PropertiesFileParticipantIdStorage.class);
        this.bind(SubscriptionRequestStorage.class).to(FileSubscriptionRequestStorage.class);
        this.bind(MessagingSettings.class).to(ConfigurableMessagingSettings.class);
        this.bind(RoutingTable.class).to(RoutingTableImpl.class).asEagerSingleton();
        this.bind(MulticastReceiverRegistry.class).to(InMemoryMulticastReceiverRegistry.class).asEagerSingleton();
        this.bind(RawMessagingPreprocessor.class).to(NoOpRawMessagingPreprocessor.class);
        this.bind(ScheduledExecutorService.class).annotatedWith((Annotation)Names.named((String)"io.joynr.messaging.scheduledthreadpool")).toProvider(DefaultScheduledExecutorServiceProvider.class);
        this.bind(StatusReceiver.class).to(DefaultStatusReceiver.class);
        this.install((Module)new StaticCapabilitiesProvisioningModule());
        this.bind(ScheduledExecutorService.class).annotatedWith((Annotation)Names.named((String)"joynr.scheduler.cleanup")).toProvider(DefaultScheduledExecutorServiceProvider.class);
        Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<JoynrMessageProcessor>(){});
    }

    @Provides
    @Singleton
    @Named(value="joynr.messaging.dispatcheraddress")
    Address getDispatcherAddress() {
        return new InProcessAddress();
    }
}

