/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy.invocation;

import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.proxy.Future;
import io.joynr.proxy.invocation.Invocation;
import io.joynr.pubsub.SubscriptionQos;
import io.joynr.pubsub.subscription.SubscriptionListener;

public abstract class SubscriptionInvocation
extends Invocation<String> {
    private String subscriptionId = "";
    private final String subscriptionName;
    private final SubscriptionQos qos;

    protected static boolean argsHasSubscriptionId(Object[] args) {
        return args[0] instanceof String;
    }

    protected static SubscriptionQos getQosParameter(Object[] args) {
        try {
            if (SubscriptionInvocation.argsHasSubscriptionId(args)) {
                return (SubscriptionQos)args[2];
            }
            return (SubscriptionQos)args[1];
        }
        catch (ClassCastException e) {
            throw new JoynrIllegalStateException("subscribeTo must be passed a SubscriptionQos");
        }
    }

    protected <T extends SubscriptionListener> T getSubscriptionListener(Object[] args) {
        try {
            if (SubscriptionInvocation.argsHasSubscriptionId(args)) {
                return (T)((SubscriptionListener)args[1]);
            }
            return (T)((SubscriptionListener)args[0]);
        }
        catch (ClassCastException e) {
            throw new JoynrIllegalStateException("subscribeTo must be passed a SubscriptionListener");
        }
    }

    public SubscriptionInvocation(Future<String> future, String subscriptionName, SubscriptionQos qos) {
        this(future, subscriptionName, qos, null);
    }

    public SubscriptionInvocation(Future<String> future, String subscriptionName, SubscriptionQos qos, String subscriptionId) {
        super(future);
        this.subscriptionName = subscriptionName;
        this.subscriptionId = subscriptionId;
        this.qos = qos;
    }

    public boolean hasSubscriptionId() {
        return this.getSubscriptionId() != null && !this.getSubscriptionId().isEmpty();
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public SubscriptionQos getQos() {
        return this.qos;
    }
}

