/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy.invocation;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.joynr.dispatcher.rpc.annotation.JoynrMulticast;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.proxy.Future;
import io.joynr.proxy.invocation.InvocationReflectionsUtils;
import io.joynr.proxy.invocation.SubscriptionInvocation;
import io.joynr.pubsub.subscription.BroadcastSubscriptionListener;
import io.joynr.pubsub.subscription.SubscriptionListener;
import java.lang.reflect.Method;
import joynr.MulticastSubscriptionQos;

public class MulticastSubscribeInvocation
extends SubscriptionInvocation {
    private final BroadcastSubscriptionListener listener;
    private Class<?>[] outParameterTypes;
    private String[] partitions;

    public MulticastSubscribeInvocation(Method method, Object[] args, Future<String> future) {
        super(future, MulticastSubscribeInvocation.getMulticastNameFromAnnotation(method), MulticastSubscribeInvocation.getQosParameter(args));
        this.listener = (BroadcastSubscriptionListener)this.getSubscriptionListener(args);
        this.outParameterTypes = InvocationReflectionsUtils.extractOutParameterTypes((SubscriptionListener)this.listener);
        this.partitions = MulticastSubscribeInvocation.extractPartitions(args);
        if (MulticastSubscribeInvocation.argsHasSubscriptionId(args)) {
            this.setSubscriptionId((String)args[0]);
        }
    }

    private static String[] extractPartitions(Object[] args) {
        if (args[args.length - 1] instanceof String[]) {
            return (String[])args[args.length - 1];
        }
        return new String[0];
    }

    private static String getMulticastNameFromAnnotation(Method method) {
        JoynrMulticast multicastAnnotation = method.getAnnotation(JoynrMulticast.class);
        if (multicastAnnotation == null) {
            throw new JoynrIllegalStateException("SubscribeTo... methods for multicasts must be annotated with JoynrMulticast annotation");
        }
        return multicastAnnotation.name();
    }

    public MulticastSubscriptionQos getQos() {
        return (MulticastSubscriptionQos)super.getQos();
    }

    public BroadcastSubscriptionListener getListener() {
        return this.listener;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"}, justification="MulticastSubscribeInvocation is just a data container and only accessed by trusted code. So exposing internal representation is by design.")
    public Class<?>[] getOutParameterTypes() {
        return this.outParameterTypes;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getPartitions() {
        return this.partitions;
    }
}

