/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy.invocation;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.joynr.dispatcher.rpc.annotation.JoynrRpcBroadcast;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.proxy.Future;
import io.joynr.proxy.invocation.InvocationReflectionsUtils;
import io.joynr.proxy.invocation.SubscriptionInvocation;
import io.joynr.pubsub.SubscriptionQos;
import io.joynr.pubsub.subscription.BroadcastSubscriptionListener;
import io.joynr.pubsub.subscription.SubscriptionListener;
import java.lang.reflect.Method;
import joynr.BroadcastFilterParameters;
import joynr.OnChangeSubscriptionQos;

public class BroadcastSubscribeInvocation
extends SubscriptionInvocation {
    private final BroadcastSubscriptionListener broadcastSubscriptionListener;
    private final BroadcastFilterParameters filterParameters;
    private final Class<?>[] outParameterTypes;

    private static BroadcastFilterParameters getFilterParameters(Object[] args) {
        try {
            if (BroadcastSubscribeInvocation.argsHasSubscriptionId(args)) {
                return (BroadcastFilterParameters)args[3];
            }
            return (BroadcastFilterParameters)args[2];
        }
        catch (ClassCastException e) {
            throw new JoynrIllegalStateException("subscribeTo must be passed a SubscriptionQos");
        }
    }

    public BroadcastSubscribeInvocation(Method method, Object[] args, Future<String> future) {
        super(future, BroadcastSubscribeInvocation.getSubscriptionNameFromAnnotation(method), BroadcastSubscribeInvocation.getQosParameter(args));
        boolean isSelectiveBroadcast = method.getAnnotation(JoynrRpcBroadcast.class) != null;
        this.broadcastSubscriptionListener = (BroadcastSubscriptionListener)this.getSubscriptionListener(args);
        this.outParameterTypes = InvocationReflectionsUtils.extractOutParameterTypes((SubscriptionListener)this.broadcastSubscriptionListener);
        this.filterParameters = isSelectiveBroadcast ? BroadcastSubscribeInvocation.getFilterParameters(args) : new BroadcastFilterParameters();
        if (BroadcastSubscribeInvocation.argsHasSubscriptionId(args)) {
            this.setSubscriptionId((String)args[0]);
        }
    }

    private static String getSubscriptionNameFromAnnotation(Method method) {
        JoynrRpcBroadcast broadcastAnnotation = method.getAnnotation(JoynrRpcBroadcast.class);
        if (broadcastAnnotation != null) {
            return broadcastAnnotation.broadcastName();
        }
        throw new JoynrIllegalStateException("SubscribeTo... methods must be annotated with JoynrRpcSubscription annotation");
    }

    public BroadcastSubscribeInvocation(String broadcastName, BroadcastSubscriptionListener broadcastSubscriptionListener, OnChangeSubscriptionQos qos, Future<String> future) {
        super(future, broadcastName, (SubscriptionQos)qos);
        this.filterParameters = null;
        this.broadcastSubscriptionListener = broadcastSubscriptionListener;
        this.outParameterTypes = InvocationReflectionsUtils.extractOutParameterTypes((SubscriptionListener)broadcastSubscriptionListener);
    }

    public BroadcastSubscriptionListener getBroadcastSubscriptionListener() {
        return this.broadcastSubscriptionListener;
    }

    public OnChangeSubscriptionQos getQos() {
        return (OnChangeSubscriptionQos)super.getQos();
    }

    public BroadcastFilterParameters getFilterParameters() {
        return this.filterParameters;
    }

    public String getBroadcastName() {
        return this.getSubscriptionName();
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"}, justification="BroadcastSubscribeInvocation is just a data container and only accessed by trusted code. So exposing internal representation is by design.")
    public Class<?>[] getOutParameterTypes() {
        return this.outParameterTypes;
    }
}

