/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy.invocation;

import com.fasterxml.jackson.core.type.TypeReference;
import io.joynr.dispatcher.rpc.annotation.JoynrRpcSubscription;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.proxy.Future;
import io.joynr.proxy.invocation.SubscriptionInvocation;
import io.joynr.pubsub.SubscriptionQos;
import io.joynr.pubsub.subscription.AttributeSubscriptionListener;
import java.lang.reflect.Method;

public class AttributeSubscribeInvocation
extends SubscriptionInvocation {
    private final AttributeSubscriptionListener<?> attributeSubscriptionListener;
    private final Class<?> attributeTypeReference;

    public AttributeSubscribeInvocation(Method method, Object[] args, Future<String> future) {
        super(future, AttributeSubscribeInvocation.getAttributeNameFromAnnotation(method), AttributeSubscribeInvocation.getQosParameter(args));
        this.attributeTypeReference = AttributeSubscribeInvocation.getAnnotationFromMethod(method).attributeType();
        this.attributeSubscriptionListener = (AttributeSubscriptionListener)this.getSubscriptionListener(args);
        if (AttributeSubscribeInvocation.argsHasSubscriptionId(args)) {
            this.setSubscriptionId((String)args[0]);
        }
    }

    private static JoynrRpcSubscription getAnnotationFromMethod(Method method) {
        JoynrRpcSubscription subscriptionAnnotation = method.getAnnotation(JoynrRpcSubscription.class);
        if (subscriptionAnnotation == null) {
            throw new JoynrIllegalStateException("SubscribeTo... methods must be annotated with JoynrRpcSubscription annotation");
        }
        return subscriptionAnnotation;
    }

    private static String getAttributeNameFromAnnotation(Method method) {
        return AttributeSubscribeInvocation.getAnnotationFromMethod(method).attributeName();
    }

    public AttributeSubscribeInvocation(String attributeName, Class<? extends TypeReference<?>> attributeTypeReference, AttributeSubscriptionListener<?> attributeSubscriptionListener, SubscriptionQos qos, Future<String> future) {
        super(future, attributeName, qos);
        this.attributeTypeReference = attributeTypeReference;
        this.attributeSubscriptionListener = attributeSubscriptionListener;
    }

    public AttributeSubscriptionListener<?> getAttributeSubscriptionListener() {
        return this.attributeSubscriptionListener;
    }

    public Class<?> getAttributeTypeReference() {
        return this.attributeTypeReference;
    }

    public String getAttributeName() {
        return this.getSubscriptionName();
    }
}

