/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.joynr.Async;
import io.joynr.Sync;
import io.joynr.arbitration.ArbitrationResult;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.dispatcher.rpc.JoynrBroadcastSubscriptionInterface;
import io.joynr.dispatcher.rpc.JoynrSubscriptionInterface;
import io.joynr.dispatcher.rpc.annotation.FireAndForget;
import io.joynr.dispatcher.rpc.annotation.JoynrMulticast;
import io.joynr.dispatcher.rpc.annotation.JoynrRpcBroadcast;
import io.joynr.exceptions.DiscoveryException;
import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.ConnectorFactory;
import io.joynr.proxy.ConnectorInvocationHandler;
import io.joynr.proxy.ConnectorStatus;
import io.joynr.proxy.Future;
import io.joynr.proxy.ICallback;
import io.joynr.proxy.ProxyInvocationHandler;
import io.joynr.proxy.invocation.AttributeSubscribeInvocation;
import io.joynr.proxy.invocation.BroadcastSubscribeInvocation;
import io.joynr.proxy.invocation.Invocation;
import io.joynr.proxy.invocation.MethodInvocation;
import io.joynr.proxy.invocation.MulticastSubscribeInvocation;
import io.joynr.proxy.invocation.SubscriptionInvocation;
import io.joynr.proxy.invocation.UnsubscribeInvocation;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import joynr.MethodMetaInformation;
import joynr.exceptions.ApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyInvocationHandlerImpl
extends ProxyInvocationHandler {
    private ConnectorFactory connectorFactory;
    private final MessagingQos qosSettings;
    private ConnectorStatus connectorStatus;
    private Lock connectorStatusLock = new ReentrantLock();
    private Condition connectorSuccessfullyFinished = this.connectorStatusLock.newCondition();
    private DiscoveryQos discoveryQos;
    private ConnectorInvocationHandler connector;
    private final String proxyParticipantId;
    private ConcurrentLinkedQueue<MethodInvocation<?>> queuedRpcList = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<SubscriptionAction> queuedSubscriptionInvocationList = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<UnsubscribeInvocation> queuedUnsubscripeInvocationList = new ConcurrentLinkedQueue();
    private String interfaceName;
    private Set<String> domains;
    private static final Logger logger = LoggerFactory.getLogger(ProxyInvocationHandlerImpl.class);

    @Inject
    public ProxyInvocationHandlerImpl(@Assisted(value="domains") Set<String> domains, @Assisted(value="interfaceName") String interfaceName, @Assisted(value="proxyParticipantId") String proxyParticipantId, @Assisted DiscoveryQos discoveryQos, @Assisted MessagingQos messagingQos, ConnectorFactory connectorFactory) {
        this.domains = domains;
        this.proxyParticipantId = proxyParticipantId;
        this.interfaceName = interfaceName;
        this.discoveryQos = discoveryQos;
        this.qosSettings = messagingQos;
        this.connectorFactory = connectorFactory;
        this.connectorStatus = ConnectorStatus.ConnectorNotAvailabe;
    }

    @CheckForNull
    private Object executeSyncMethod(Method method, Object[] args) throws ApplicationException {
        return this.executeMethodWithCaller(method, args, new ConnectorCaller(){

            @Override
            public Object call(Method method, Object[] args) throws ApplicationException {
                return ProxyInvocationHandlerImpl.this.connector.executeSyncMethod(method, args);
            }
        });
    }

    @CheckForNull
    private Object executeOneWayMethod(Method method, Object[] args) throws ApplicationException {
        return this.executeMethodWithCaller(method, args, new ConnectorCaller(){

            @Override
            public Object call(Method method, Object[] args) {
                ProxyInvocationHandlerImpl.this.connector.executeOneWayMethod(method, args);
                return null;
            }
        });
    }

    private Object executeMethodWithCaller(Method method, Object[] args, ConnectorCaller connectorCaller) throws ApplicationException {
        try {
            if (this.waitForConnectorFinished()) {
                if (this.connector == null) {
                    throw new IllegalStateException("connector was null although arbitration finished successfully");
                }
                return connectorCaller.call(method, args);
            }
        }
        catch (JoynrRuntimeException | ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JoynrRuntimeException((Throwable)e);
        }
        if (this.throwable != null) {
            if (this.throwable instanceof JoynrRuntimeException) {
                throw (JoynrRuntimeException)this.throwable;
            }
            throw new JoynrRuntimeException(this.throwable);
        }
        throw new DiscoveryException("Arbitration and Connector failed: domain: " + this.domains + " interface: " + this.interfaceName + " qos: " + this.discoveryQos + ": Arbitration could not be finished in time.");
    }

    public boolean waitForConnectorFinished() throws InterruptedException {
        this.connectorStatusLock.lock();
        try {
            if (this.connectorStatus == ConnectorStatus.ConnectorSuccesful) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.connectorSuccessfullyFinished.await(this.discoveryQos.getDiscoveryTimeoutMs(), TimeUnit.MILLISECONDS);
            return bl;
        }
        finally {
            this.connectorStatusLock.unlock();
        }
    }

    public boolean isConnectorReady() {
        this.connectorStatusLock.lock();
        try {
            if (this.connectorStatus == ConnectorStatus.ConnectorSuccesful) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.connectorStatusLock.unlock();
        }
    }

    private void sendQueuedSubscriptionInvocations() {
        SubscriptionAction currentSubscriptionAction;
        while ((currentSubscriptionAction = this.queuedSubscriptionInvocationList.poll()) != null) {
            try {
                currentSubscriptionAction.subscribe();
                continue;
            }
            catch (JoynrRuntimeException e) {
                currentSubscriptionAction.fail((JoynrException)e);
                continue;
            }
            catch (Exception e) {
                currentSubscriptionAction.fail((JoynrException)new JoynrRuntimeException((Throwable)e));
                continue;
            }
            break;
        }
        return;
    }

    private void sendQueuedUnsubscribeInvocations() {
        UnsubscribeInvocation unsubscribeInvocation;
        while ((unsubscribeInvocation = this.queuedUnsubscripeInvocationList.poll()) != null) {
            try {
                this.connector.executeSubscriptionMethod(unsubscribeInvocation);
                continue;
            }
            catch (JoynrRuntimeException e) {
                unsubscribeInvocation.getFuture().onFailure((JoynrException)e);
                continue;
            }
            catch (Exception e) {
                unsubscribeInvocation.getFuture().onFailure((JoynrException)new JoynrRuntimeException((Throwable)e));
                continue;
            }
            break;
        }
        return;
    }

    private void setFutureErrorState(Invocation<?> invocation, JoynrRuntimeException e) {
        invocation.getFuture().onFailure((JoynrException)e);
    }

    private void sendQueuedInvocations() {
        MethodInvocation<?> currentRPC;
        while ((currentRPC = this.queuedRpcList.poll()) != null) {
            try {
                this.connector.executeAsyncMethod(currentRPC.getMethod(), currentRPC.getArgs(), currentRPC.getFuture());
                continue;
            }
            catch (JoynrRuntimeException e) {
                currentRPC.getFuture().onFailure((JoynrException)e);
                continue;
            }
            catch (Exception e) {
                currentRPC.getFuture().onFailure((JoynrException)new JoynrRuntimeException((Throwable)e));
                continue;
            }
            break;
        }
        return;
    }

    @Override
    public void createConnector(ArbitrationResult result) {
        this.connector = this.connectorFactory.create(this.proxyParticipantId, result, this.qosSettings);
        this.connectorStatusLock.lock();
        try {
            this.connectorStatus = ConnectorStatus.ConnectorSuccesful;
            this.connectorSuccessfullyFinished.signalAll();
            if (this.connector != null) {
                this.sendQueuedInvocations();
                this.sendQueuedSubscriptionInvocations();
                this.sendQueuedUnsubscribeInvocations();
            }
        }
        finally {
            this.connectorStatusLock.unlock();
        }
    }

    @CheckForNull
    private Object executeSubscriptionMethod(Method method, Object[] args) {
        Future future = new Future();
        if (method.getName().startsWith("subscribeTo")) {
            if (JoynrSubscriptionInterface.class.isAssignableFrom(method.getDeclaringClass())) {
                this.executeAttributeSubscriptionMethod(method, args, (Future<String>)future);
            } else if (method.getAnnotation(JoynrRpcBroadcast.class) != null) {
                this.executeBroadcastSubscriptionMethod(method, args, (Future<String>)future);
            } else if (method.getAnnotation(JoynrMulticast.class) != null) {
                this.executeMulticastSubscriptionMethod(method, args, (Future<String>)future);
            } else {
                throw new JoynrRuntimeException("Method " + method + " not declared in JoynrSubscriptionInterface or annotated with either @JoynrRpcBroadcast or @JoynrMulticast.");
            }
            return future;
        }
        if (method.getName().startsWith("unsubscribeFrom")) {
            return this.unsubscribe(new UnsubscribeInvocation(method, args, (Future<String>)future)).getSubscriptionId();
        }
        throw new JoynrIllegalStateException("Called unknown method in one of the subscription interfaces.");
    }

    private void executeAttributeSubscriptionMethod(Method method, Object[] args, Future<String> future) {
        final AttributeSubscribeInvocation attributeSubscription = new AttributeSubscribeInvocation(method, args, future);
        this.queueOrExecuteSubscriptionInvocation(attributeSubscription, new SubscriptionAction(future){

            @Override
            public void subscribe() {
                ProxyInvocationHandlerImpl.this.connector.executeSubscriptionMethod(attributeSubscription);
            }
        });
    }

    private void executeBroadcastSubscriptionMethod(Method method, Object[] args, Future<String> future) {
        final BroadcastSubscribeInvocation broadcastSubscription = new BroadcastSubscribeInvocation(method, args, future);
        this.queueOrExecuteSubscriptionInvocation(broadcastSubscription, new SubscriptionAction(future){

            @Override
            public void subscribe() {
                ProxyInvocationHandlerImpl.this.connector.executeSubscriptionMethod(broadcastSubscription);
            }
        });
    }

    private void executeMulticastSubscriptionMethod(Method method, Object[] args, Future<String> future) {
        final MulticastSubscribeInvocation multicastSubscription = new MulticastSubscribeInvocation(method, args, future);
        this.queueOrExecuteSubscriptionInvocation(multicastSubscription, new SubscriptionAction(future){

            @Override
            public void subscribe() {
                ProxyInvocationHandlerImpl.this.connector.executeSubscriptionMethod(multicastSubscription);
            }
        });
    }

    private void queueOrExecuteSubscriptionInvocation(SubscriptionInvocation subscriptionInvocation, SubscriptionAction subscriptionMethodExecutor) {
        this.connectorStatusLock.lock();
        try {
            if (!this.isConnectorReady()) {
                this.queuedSubscriptionInvocationList.offer(subscriptionMethodExecutor);
                return;
            }
        }
        finally {
            this.connectorStatusLock.unlock();
        }
        try {
            subscriptionMethodExecutor.subscribe();
        }
        catch (JoynrRuntimeException e) {
            logger.error("error executing subscription: {} : {}", (Object)subscriptionInvocation.getSubscriptionName(), (Object)e.getMessage());
            this.setFutureErrorState(subscriptionInvocation, e);
        }
        catch (Exception e) {
            logger.error("error executing subscription: {} : {}", (Object)subscriptionInvocation.getSubscriptionName(), (Object)e.getMessage());
            this.setFutureErrorState(subscriptionInvocation, new JoynrRuntimeException((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Object executeAsyncMethod(Method method, Object[] args) throws IllegalAccessException, Exception {
        Future future = (Future)method.getReturnType().getConstructor(new Class[0]).newInstance(new Object[0]);
        this.connectorStatusLock.lock();
        try {
            if (!this.isConnectorReady()) {
                this.queuedRpcList.offer(new MethodInvocation(method, args, future));
                Future future2 = future;
                return future2;
            }
        }
        finally {
            this.connectorStatusLock.unlock();
        }
        return this.connector.executeAsyncMethod(method, args, future);
    }

    private UnsubscribeInvocation unsubscribe(UnsubscribeInvocation unsubscribeInvocation) {
        this.connectorStatusLock.lock();
        try {
            if (!this.isConnectorReady()) {
                this.queuedUnsubscripeInvocationList.offer(unsubscribeInvocation);
                UnsubscribeInvocation unsubscribeInvocation2 = unsubscribeInvocation;
                return unsubscribeInvocation2;
            }
        }
        finally {
            this.connectorStatusLock.unlock();
        }
        try {
            this.connector.executeSubscriptionMethod(unsubscribeInvocation);
        }
        catch (JoynrRuntimeException e) {
            logger.error("error executing unsubscription: {} : {}", (Object)unsubscribeInvocation.getSubscriptionId(), (Object)e.getMessage());
            this.setFutureErrorState(unsubscribeInvocation, e);
        }
        catch (Exception e) {
            logger.error("error executing unsubscription: {} : {}", (Object)unsubscribeInvocation.getSubscriptionId(), (Object)e.getMessage());
            this.setFutureErrorState(unsubscribeInvocation, new JoynrRuntimeException((Throwable)e));
        }
        return unsubscribeInvocation;
    }

    @Override
    @CheckForNull
    public Object invoke(@Nonnull Method method, Object[] args) throws ApplicationException {
        logger.trace("calling proxy.{}({}) on domain: {} and interface {}, proxy participant ID: {}", new Object[]{method.getName(), args, this.domains, this.interfaceName, this.proxyParticipantId});
        Class<?> methodInterfaceClass = method.getDeclaringClass();
        try {
            if (JoynrSubscriptionInterface.class.isAssignableFrom(methodInterfaceClass) || JoynrBroadcastSubscriptionInterface.class.isAssignableFrom(methodInterfaceClass)) {
                return this.executeSubscriptionMethod(method, args);
            }
            if (methodInterfaceClass.getAnnotation(FireAndForget.class) != null) {
                return this.executeOneWayMethod(method, args);
            }
            if (methodInterfaceClass.getAnnotation(Sync.class) != null) {
                return this.executeSyncMethod(method, args);
            }
            if (methodInterfaceClass.getAnnotation(Async.class) != null) {
                return this.executeAsyncMethod(method, args);
            }
            throw new JoynrIllegalStateException("Method is not part of sync, async or subscription interface");
        }
        catch (JoynrRuntimeException | ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JoynrRuntimeException((Throwable)e);
        }
    }

    @Override
    public void abort(JoynrRuntimeException exception) {
        this.setThrowableForInvoke(exception);
        for (MethodInvocation<?> methodInvocation : this.queuedRpcList) {
            try {
                MethodMetaInformation metaInfo = new MethodMetaInformation(methodInvocation.getMethod());
                int callbackIndex = metaInfo.getCallbackIndex();
                if (callbackIndex > -1) {
                    ICallback callback = (ICallback)methodInvocation.getArgs()[callbackIndex];
                    callback.onFailure(exception);
                }
            }
            catch (Exception metaInfoException) {
                logger.error("aborting call to method: " + methodInvocation.getMethod().getName() + " but unable to call onError callback because of: " + metaInfoException.getMessage(), (Throwable)metaInfoException);
            }
            methodInvocation.getFuture().onFailure((JoynrException)exception);
        }
        for (Invocation invocation : this.queuedUnsubscripeInvocationList) {
            invocation.getFuture().onFailure((JoynrException)exception);
        }
        for (SubscriptionAction subscriptionAction : this.queuedSubscriptionInvocationList) {
            subscriptionAction.fail((JoynrException)exception);
        }
    }

    private static abstract class SubscriptionAction {
        private Future<String> future;

        private SubscriptionAction(Future<String> future) {
            this.future = future;
        }

        protected abstract void subscribe();

        private void fail(JoynrException joynrException) {
            this.future.onFailure(joynrException);
        }
    }

    private static interface ConnectorCaller {
        public Object call(Method var1, Object[] var2) throws ApplicationException;
    }
}

