/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy;

import com.google.common.collect.Sets;
import com.google.inject.name.Named;
import io.joynr.proxy.ProxyBuilder;
import io.joynr.proxy.ProxyBuilderDefaultImpl;
import io.joynr.proxy.ProxyBuilderFactory;
import io.joynr.proxy.ProxyInvocationHandlerFactory;
import java.util.Set;
import javax.inject.Inject;
import joynr.system.DiscoveryAsync;

public class ProxyBuilderFactoryImpl
implements ProxyBuilderFactory {
    private final DiscoveryAsync localDiscoveryAggregator;
    private final ProxyInvocationHandlerFactory proxyInvocationHandlerFactory;
    private final long maxMessagingTtl;
    private final long defaultDiscoveryTimeoutMs;
    private final long defaultDiscoveryRetryIntervalMs;

    @Inject
    public ProxyBuilderFactoryImpl(DiscoveryAsync localDiscoveryAggregator, ProxyInvocationHandlerFactory proxyInvocationHandlerFactory, @Named(value="joynr.messaging.maxttlms") long maxMessagingTtl, @Named(value="joynr.discovery.defaulttimeoutms") long defaultDiscoveryTimeoutMs, @Named(value="joynr.discovery.defaultretryintervalms") long defaultDiscoveryRetryIntervalMs) {
        this.localDiscoveryAggregator = localDiscoveryAggregator;
        this.proxyInvocationHandlerFactory = proxyInvocationHandlerFactory;
        this.maxMessagingTtl = maxMessagingTtl;
        this.defaultDiscoveryTimeoutMs = defaultDiscoveryTimeoutMs;
        this.defaultDiscoveryRetryIntervalMs = defaultDiscoveryRetryIntervalMs;
    }

    @Override
    public <T> ProxyBuilder<T> get(String domain, Class<T> interfaceClass) {
        return this.get(Sets.newHashSet((Object[])new String[]{domain}), interfaceClass);
    }

    @Override
    public <T> ProxyBuilder<T> get(Set<String> domains, Class<T> interfaceClass) {
        return new ProxyBuilderDefaultImpl<T>(this.localDiscoveryAggregator, domains, interfaceClass, this.proxyInvocationHandlerFactory, this.maxMessagingTtl, this.defaultDiscoveryTimeoutMs, this.defaultDiscoveryRetryIntervalMs);
    }
}

